/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.apache.jackrabbit.core.journal.JournalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockableFileRevision {
    private static final Logger log = LoggerFactory.getLogger(LockableFileRevision.class);
    private final File file;
    private RandomAccessFile raf;
    private FileLock lock;
    private int locks;

    public LockableFileRevision(File file) {
        this.file = file;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            String msg = "I/O error while attempting to create new file '" + file + "': " + e.getMessage();
            log.warn(msg);
        }
    }

    public synchronized void lock(boolean shared) throws JournalException {
        if (this.lock == null) {
            try {
                this.raf = new RandomAccessFile(this.file, shared ? "r" : "rw");
                this.lock = this.raf.getChannel().lock(0L, Long.MAX_VALUE, shared);
            }
            catch (IOException e) {
                String msg = "I/O error occurred.";
                throw new JournalException(msg, e);
            }
            finally {
                if (this.lock == null && this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (IOException e) {
                        String msg = "I/O error while closing file " + this.file.getPath() + ": " + e.getMessage();
                        log.warn(msg);
                    }
                    this.raf = null;
                }
            }
        }
        ++this.locks;
    }

    public synchronized void unlock() {
        if (this.lock != null && --this.locks == 0) {
            String msg;
            try {
                this.lock.release();
            }
            catch (IOException e) {
                msg = "I/O error while releasing lock: " + e.getMessage();
                log.warn(msg);
            }
            this.lock = null;
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    msg = "I/O error while closing file: " + e.getMessage();
                    log.warn(msg);
                }
            }
            this.raf = null;
        }
    }

    public long get() throws JournalException {
        this.lock(true);
        try {
            long value = 0L;
            if (this.raf.length() > 0L) {
                this.raf.seek(0L);
                value = this.raf.readLong();
            }
            long l = value;
            return l;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred: ", e);
        }
        finally {
            this.unlock();
        }
    }

    public void set(long value) throws JournalException {
        this.lock(false);
        try {
            this.raf.seek(0L);
            this.raf.writeLong(value);
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", e);
        }
        finally {
            this.unlock();
        }
    }
}

