/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.NullOutputStream;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit394Checksums
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit394Checksums.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        Type type = Type.valueOf(DeployableArtifact.class);
        Collection subtypes = DescriptorRegistry.getSubtypes((Type)type);
        for (Type subtype : subtypes) {
            try {
                this.upgradeNodesOfType(repository, subtype);
            }
            catch (RepositoryException e) {
                throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new UpgradeException("Upgrade failed due to", (Exception)e);
            }
        }
        return true;
    }

    private void upgradeNodesOfType(RawRepository repository, Type type) throws RepositoryException, IOException {
        if (!type.getDescriptor().isVirtual()) {
            logger.info("Reading all nodes of type [{}]", (Object)type);
            List nodesByType = repository.findNodesByType(type);
            for (Node node : nodesByType) {
                this.upgradeNode(type, node, repository);
            }
        }
    }

    private void upgradeNode(Type type, Node node, RawRepository repository) throws RepositoryException, IOException {
        if (node.hasProperty("checksum")) {
            logger.debug("Checking whether checksum of [{}] is broken", (Object)node.getPath());
            String checksum = node.getProperty("checksum").getString();
            if (this.isPossiblyCorrupt(checksum)) {
                logger.debug("Checksum [{}] of node [{}] needs verification", (Object)checksum, (Object)node.getPath());
                String realChecksum = this.calculateRealChecksum(type, node);
                if (this.isReallyCorrupt(checksum, realChecksum)) {
                    logger.info("Fixing checksum [{}] of node [{}] to [{}]", new Object[]{checksum, node.getPath(), realChecksum});
                    node.setProperty("checksum", realChecksum);
                }
            }
        } else {
            logger.debug("Skipping node [{}] as it has no checksum", (Object)node.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateRealChecksum(Type type, Node node) throws IOException {
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        InputSupplier<InputStream> inputSupplier = this.getDataInputSupplier(node);
        if (type.isSubTypeOf(Type.valueOf(FolderArtifact.class))) {
            Exploder.calculateCheckSum(inputSupplier, (MessageDigest)sha1);
        } else {
            InputStream input = (InputStream)inputSupplier.getInput();
            try {
                ByteStreams.copy((InputStream)new DigestInputStream(input, sha1), (OutputStream)new NullOutputStream());
            }
            finally {
                Closeables.closeQuietly((Closeable)input);
            }
        }
        return JavaCryptoUtils.digest((MessageDigest)sha1);
    }

    private InputSupplier<InputStream> getDataInputSupplier(final Node node) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                try {
                    return node.getProperty("$data").getBinary().getStream();
                }
                catch (RepositoryException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @VisibleForTesting
    boolean isReallyCorrupt(String checksum, String realChecksum) {
        char[] checksumChars = checksum.toCharArray();
        char[] realChecksumChars = realChecksum.toCharArray();
        for (int i = 0; i < checksumChars.length; ++i) {
            char checksumChar = checksumChars[i];
            char realChecksumChar = realChecksumChars[i];
            if (checksumChar == realChecksumChar) continue;
            if (realChecksumChar == '0') {
                realChecksumChar = realChecksumChars[i + 1];
                return checksumChar == realChecksumChar;
            }
            return false;
        }
        return false;
    }

    @VisibleForTesting
    boolean isPossiblyCorrupt(String checksum) {
        return checksum.matches("^[0-9A-Fa-f]{20,39}$");
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.9.4");
    }
}

