/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit396FolderChecksums
extends Upgrade {
    public static final int BATCH_SIZE = 500;
    private static String CHECKSUM_PROPERTY_NAME = "checksum";
    private static final Logger logger = LoggerFactory.getLogger(Deployit396FolderChecksums.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.9.6 Upgrade: Update Folder Checksums ***");
        Type folderType = Type.valueOf(FolderArtifact.class);
        ArrayList types = Lists.newArrayList((Iterable)DescriptorRegistry.getSubtypes((Type)folderType));
        types.add(folderType);
        for (Type type : types) {
            try {
                this.upgradeNodesOfType(repository, type);
            }
            catch (RepositoryException e) {
                throw new UpgradeException("Upgrade failed due to", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new UpgradeException("Upgrade failed due to", (Exception)e);
            }
        }
        logger.info("*** Done Deployit 3.9.6 upgrade -- Update Folder Checksums ***");
        return true;
    }

    private void upgradeNodesOfType(RawRepository repository, Type type) throws RepositoryException, IOException {
        logger.info("Searching all nodes of type: {}", (Object)type);
        List nodes = repository.findNodesByType(type);
        logger.info("Found {} candidate nodes of type: {}", (Object)nodes.size(), (Object)type);
        if (nodes.isEmpty()) {
            return;
        }
        logger.info("Calculating checksums, please wait...");
        Session session = ((RawRepositoryImpl)repository).getSession();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (node.hasProperty(CHECKSUM_PROPERTY_NAME)) {
                String currentChecksum = node.getProperty(CHECKSUM_PROPERTY_NAME).getString();
                if (Strings.isNullOrEmpty((String)currentChecksum)) {
                    this.updateChecksum(node);
                } else if (currentChecksum.equals(this.calculateChecksum(node, false))) {
                    this.updateChecksum(node);
                } else {
                    String ciId = JcrPathHelper.getIdFromAbsolutePath((String)node.getPath());
                    logger.debug("Checksum of {} does not need to be updated.", (Object)ciId);
                }
            } else {
                this.updateChecksum(node);
            }
            if (i <= 0 || i % 500 != 0) continue;
            logger.info("Flushing changes to repository");
            session.save();
        }
    }

    private void updateChecksum(Node node) throws RepositoryException, IOException {
        String ciId = JcrPathHelper.getIdFromAbsolutePath((String)node.getPath());
        String newAlgorithmChecksum = this.calculateChecksum(node, true);
        logger.info("Updating checksum property of {} :: {}", (Object)ciId, (Object)newAlgorithmChecksum);
        node.setProperty(CHECKSUM_PROPERTY_NAME, newAlgorithmChecksum);
    }

    private String calculateChecksum(Node node, boolean digestPaths) throws IOException {
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        Exploder.calculateCheckSum(this.getDataInputSupplier(node), (MessageDigest)sha1, (boolean)digestPaths);
        return JavaCryptoUtils.digest((MessageDigest)sha1);
    }

    private InputSupplier<InputStream> getDataInputSupplier(final Node node) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                try {
                    return node.getProperty("$data").getBinary().getStream();
                }
                catch (RepositoryException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.9.6");
    }
}

