/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedPropertySetter {
    private RepositoryService repository;
    private final TypeCalculator calculator;
    private static final Set<String> UDM_FIELDS = Sets.newHashSet((Object[])new String[]{"placeholders", "deployable", "container"});
    private static final Set<String> DEPLOYED_APPLICATION_FIELDS = Sets.newHashSet((Object[])new String[]{"deployeds", "version", "environment"});
    private static final Logger logger = LoggerFactory.getLogger(DeployedPropertySetter.class);

    @Autowired
    public DeployedPropertySetter(RepositoryService repository, TypeCalculator typeCalculator) {
        this.repository = repository;
        this.calculator = typeCalculator;
    }

    public void setProperties(EmbeddedDeployedContainer<?, ?> deployed, EmbeddedDeployedContainer<?, ?> existingDeployed, ConsolidatedDictionary dictionary) {
        Checks.checkArgument((existingDeployed == null || deployed.getType().equals((Object)existingDeployed.getType()) ? 1 : 0) != 0, (String)"New and existing deployed types should be equal when upgrading (%s)", (Object[])new Object[]{deployed.getType()});
        for (PropertyDescriptor deployedPropDesc : deployed.getType().getDescriptor().getPropertyDescriptors()) {
            String name = deployedPropDesc.getName();
            if (UDM_FIELDS.contains(name)) continue;
            if (this.isEmbeddedProperty(deployedPropDesc)) {
                this.generateEmbeddeds(deployed, deployedPropDesc, dictionary);
                continue;
            }
            ConfigurationItem deployable = (ConfigurationItem)deployed.getProperty("deployable");
            ConfigurationItem existingDeployable = existingDeployed == null ? null : (ConfigurationItem)existingDeployed.getProperty("deployable");
            this.setProperty((ConfigurationItem)deployed, (ConfigurationItem)existingDeployed, deployable, existingDeployable, dictionary, deployedPropDesc);
        }
    }

    public void setProperties(DeployedApplication deployedApplication, DeployedApplication existingDeployedApplication, ConsolidatedDictionary dictionary) {
        for (PropertyDescriptor deployedPropDesc : deployedApplication.getType().getDescriptor().getPropertyDescriptors()) {
            String name = deployedPropDesc.getName();
            if (DEPLOYED_APPLICATION_FIELDS.contains(name)) continue;
            Version version = deployedApplication.getVersion();
            Version existingVersion = existingDeployedApplication == null ? null : existingDeployedApplication.getVersion();
            this.setProperty((ConfigurationItem)deployedApplication, (ConfigurationItem)existingDeployedApplication, (ConfigurationItem)version, (ConfigurationItem)existingVersion, dictionary, deployedPropDesc);
        }
    }

    public void setProperty(ConfigurationItem deployed, ConfigurationItem existingDeployed, ConfigurationItem deployable, ConfigurationItem existingDeployable, ConsolidatedDictionary dictionary, PropertyDescriptor deployedPropDesc) {
        String name = deployedPropDesc.getName();
        Object existingDeployedValue = this.getValueIfExists(existingDeployed, name);
        Object existingDeployableValue = this.getValueIfExists(existingDeployable, name);
        Object deployableValue = this.getValueIfExists(deployable, name);
        PropertyDescriptor deployablePropDesc = deployable.getType().getDescriptor().getPropertyDescriptor(name);
        Object valueToSet = existingDeployedValue;
        PropertyDescriptor valueToSetPropDesc = deployedPropDesc;
        if (existingDeployableValue != null && MustachePlaceholderScanner.hasPlaceholders((Object)existingDeployableValue, (PropertyDescriptor)deployablePropDesc)) {
            valueToSet = deployableValue;
            valueToSetPropDesc = deployablePropDesc;
        } else if (existingDeployableValue == null && deployableValue != null) {
            valueToSet = deployableValue;
            valueToSetPropDesc = deployablePropDesc;
        } else if (existingDeployableValue != null) {
            PropertyDescriptor existingDeployablePropDesc = existingDeployable.getType().getDescriptor().getPropertyDescriptor(name);
            Object resolvedExistingDeployableValue = this.convertIfNeeded(existingDeployableValue, existingDeployablePropDesc, deployedPropDesc);
            if (existingDeployedValue != null && resolvedExistingDeployableValue.toString().equals(existingDeployedValue.toString())) {
                valueToSet = deployableValue;
                valueToSetPropDesc = deployablePropDesc;
            }
        }
        if (this.isNullOrEmpty(valueToSet, valueToSetPropDesc)) {
            this.setDeployedFromDictionary(deployed, dictionary, deployedPropDesc, deployablePropDesc);
            return;
        }
        try {
            Object deployedPropertyValue = dictionary.resolve(valueToSet, valueToSetPropDesc);
            this.checkWhetherValueIsSecureAndPropertyIsPassword(deployedPropertyValue, deployedPropDesc, valueToSet);
            this.setSilently(deployed, deployedPropDesc, this.convertIfNeeded(deployedPropertyValue, valueToSetPropDesc, deployedPropDesc));
        }
        catch (DictionaryValueException e) {
            this.setSilently(deployed, deployedPropDesc, existingDeployedValue);
            logger.info("Could not resolve dictionary keys for property " + deployablePropDesc + " on " + deployed + ".");
            logger.trace("Exception was", (Throwable)e);
        }
    }

    private void setSilently(ConfigurationItem ci, PropertyDescriptor pd, Object value) {
        try {
            pd.set(ci, value);
        }
        catch (RuntimeException exc) {
            logger.error("Could not convert (resolved) value to correct type for property " + pd + " of " + ci + ". Property will be left empty.", (Throwable)exc);
        }
    }

    private Object getValueIfExists(ConfigurationItem configurationItem, String name) {
        if (configurationItem == null || !configurationItem.hasProperty(name)) {
            return null;
        }
        return configurationItem.getProperty(name);
    }

    private void checkWhetherValueIsSecureAndPropertyIsPassword(Object value, PropertyDescriptor deployedDesc, Object deployablePropertyValue) throws DictionaryValueException {
        if (value instanceof EncryptedStringValue && !deployedDesc.isPassword()) {
            logger.warn("The deployable value [{}] resolved to an encrypted value, but property [{}] is not a password field.", deployablePropertyValue, (Object)deployedDesc.getFqn());
            throw new DictionaryValueException("The deployable value [%s] resolved to an encrypted value, but property [%s] is not a password field.", new Object[]{deployablePropertyValue, deployedDesc.getFqn()});
        }
    }

    private boolean isNullOrEmpty(Object value, PropertyDescriptor pd) {
        if (value == null) {
            return true;
        }
        switch (pd.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case STRING: 
            case ENUM: 
            case DATE: 
            case CI: {
                return Strings.isNullOrEmpty((String)value.toString());
            }
            case SET_OF_STRING: 
            case SET_OF_CI: 
            case LIST_OF_STRING: 
            case LIST_OF_CI: {
                return ((Collection)value).isEmpty();
            }
            case MAP_STRING_STRING: {
                return ((Map)value).isEmpty();
            }
        }
        throw new IllegalStateException("Unsupported property kind: " + pd.getKind() + " for property: " + pd.getFqn());
    }

    private void setDeployedFromDictionary(ConfigurationItem deployed, ConsolidatedDictionary dictionary, PropertyDescriptor deployedPropDesc, PropertyDescriptor deployablePropDesc) {
        if (dictionary.containsKey(deployedPropDesc.getFqn())) {
            Object value = dictionary.get(deployedPropDesc.getFqn());
            value = this.convertIfNeeded(value, deployablePropDesc, deployedPropDesc);
            deployedPropDesc.set(deployed, value);
        }
    }

    private Object convertIfNeeded(Object valueToSet, PropertyDescriptor deployablePropDesc, PropertyDescriptor deployedPropDesc) {
        if (valueToSet == null) {
            return valueToSet;
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.CI) {
            return this.repository.read(valueToSet.toString());
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.SET_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.SET_OF_CI) {
            return Sets.newHashSet(this.getCollectionOfCis(this.splitValue(valueToSet)));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.LIST_OF_STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(valueToSet));
        }
        if (this.optionalKind(deployablePropDesc, PropertyKind.STRING) && deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI) {
            return Lists.newArrayList(this.getCollectionOfCis(this.splitValue(valueToSet)));
        }
        if (deployedPropDesc.getKind() == PropertyKind.STRING) {
            if (deployedPropDesc instanceof EncryptedStringValue && !deployedPropDesc.isPassword()) {
                logger.warn("Going to write a Encrypted value as plaintext in [{}], as it is not a password field.", (Object)deployedPropDesc);
            }
            return valueToSet.toString();
        }
        if (valueToSet instanceof StringValue) {
            return valueToSet.toString();
        }
        return valueToSet;
    }

    private Collection<String> splitValue(Object valueToSet) {
        Checks.checkArgument((valueToSet instanceof String || valueToSet instanceof StringValue ? 1 : 0) != 0, (String)"Should be String or StringValue to split.", (Object[])new Object[0]);
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings();
        return Lists.newArrayList((Iterable)splitter.split((CharSequence)valueToSet.toString()));
    }

    private boolean optionalKind(PropertyDescriptor deployablePropDesc, PropertyKind kind) {
        return deployablePropDesc == null || deployablePropDesc.getKind() == kind;
    }

    private Collection<ConfigurationItem> getCollectionOfCis(Object valueToSet) {
        ArrayList cis = Lists.newArrayList();
        for (String s : (Collection)valueToSet) {
            cis.add(this.repository.read(s));
        }
        return cis;
    }

    private void generateEmbeddeds(EmbeddedDeployedContainer<?, ?> deployed, final PropertyDescriptor deployedPropDesc, ConsolidatedDictionary dictionary) {
        ConfigurationItem deployable = deployed.getDeployable();
        String name = deployedPropDesc.getName();
        AbstractCollection embeddedDeployeds = deployedPropDesc.getKind() == PropertyKind.LIST_OF_CI ? Lists.newArrayList() : Sets.newHashSet();
        PropertyDescriptor deployableProperty = deployable.getType().getDescriptor().getPropertyDescriptor(name);
        if (deployableProperty == null) {
            logger.info("Deployed [{}] has embedded deployeds in property [{}] but deployable [{}] has no such property.", new Object[]{deployed.getId(), deployedPropDesc.getFqn(), deployable.getId()});
            return;
        }
        Collection embeddedDeployables = (Collection)deployableProperty.get(deployable);
        for (EmbeddedDeployable embeddedDeployable : embeddedDeployables) {
            List<Type> embeddedDeployedTypes = this.calculator.findAllMostSpecificDeployedTypesForDeployableAndContainerTypes(embeddedDeployable.getType(), deployed.getType());
            Collection filtered = Collections2.filter(embeddedDeployedTypes, (Predicate)new Predicate<Type>(){

                public boolean apply(Type input) {
                    return input.instanceOf(deployedPropDesc.getReferencedType());
                }
            });
            if (filtered.isEmpty()) {
                logger.info("Not found a matching EmbeddedDeployed type for [{}] and [{}]", (Object)embeddedDeployable.getType(), (Object)deployed.getType());
                continue;
            }
            if (filtered.size() > 1) {
                logger.error("Found more than 1 ({}) compatible EmbeddedDeployed type for [{}] and [{}]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
                throw new Checks.IncorrectArgumentException("Found more than 1 (%s) compatible EmbeddedDeployed type for [%s] and [%s]", new Object[]{filtered, embeddedDeployable.getType(), deployed.getType()});
            }
            Type embeddedDeployedType = (Type)filtered.iterator().next();
            EmbeddedDeployed embeddedDeployed = (EmbeddedDeployed)embeddedDeployedType.getDescriptor().newInstance(IdGenerator.generateId(deployed, (String)embeddedDeployable.getId()));
            embeddedDeployed.setDeployable((ConfigurationItem)embeddedDeployable);
            embeddedDeployed.setContainer(deployed);
            if (MustachePlaceholderScanner.hasPlaceholders((String)embeddedDeployed.getName())) {
                try {
                    dictionary.resolveDeployedName((EmbeddedDeployedContainer)embeddedDeployed);
                }
                catch (DictionaryValueException e) {
                    throw new DeployedGenerator.IncorrectDeployedException(e, "Couldn't generate name for deployed from [%s]", embeddedDeployable.getId());
                }
            }
            embeddedDeployeds.add(embeddedDeployed);
            this.setProperties((EmbeddedDeployedContainer<?, ?>)embeddedDeployed, null, dictionary);
        }
        deployedPropDesc.set(deployed, (Object)embeddedDeployeds);
    }

    private boolean isEmbeddedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && (propertyDescriptor.getKind() == PropertyKind.SET_OF_CI || propertyDescriptor.getKind() == PropertyKind.LIST_OF_CI) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }
}

