/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.reader.ManifestReader;
import com.xebialabs.deployit.util.TFiles;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlManifestReader
implements ManifestReader {
    private Element element;

    public XmlManifestReader(ImportSource source) {
        File packageFile = source.getFile();
        this.element = this.readXmlManifest(packageFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element readXmlManifest(File packageFile) {
        TFile manifest = new TFile(packageFile, "deployit-manifest.xml");
        try {
            Element element;
            TFileInputStream is = new TFileInputStream((File)manifest);
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                element = saxBuilder.build((InputStream)is).getRootElement();
            }
            catch (Throwable throwable) {
                try {
                    Closeables.closeQuietly((Closeable)is);
                    throw throwable;
                }
                catch (JDOMException e) {
                    throw new ImporterException(e, "Could not read manifest file, invalid xml.", new Object[0]);
                }
                catch (IOException e) {
                    throw new ImporterException(e, "Could not read manifest", new Object[0]);
                }
            }
            Closeables.closeQuietly((Closeable)is);
            return element;
        }
        finally {
            TFiles.umountQuietly((TFile)manifest);
            TFiles.umountQuietly((TFile)new TFile(packageFile));
        }
    }

    @Override
    public void readPackageData(PackageInfo packageInfo, ImportingContext context) {
        XmlManifestReader.check(!Strings.isBlank((String)this.element.getAttributeValue("application")), "Missing or empty required attribute 'application' in XML Manifest for [%s]", packageInfo.getSource().getFile().getName());
        XmlManifestReader.check(!Strings.isBlank((String)this.element.getAttributeValue("version")), "Missing or empty required attribute 'version' in XML Manifest for [%s]", packageInfo.getSource().getFile().getName());
        packageInfo.setApplicationName(this.element.getAttributeValue("application"));
        packageInfo.setApplicationVersion(this.element.getAttributeValue("version"));
    }

    private static void check(boolean bool, String template, Object ... args) {
        if (!bool) {
            throw new ImporterException(template, args);
        }
    }

    @Override
    public ManifestReader.ManifestCiReader versionReader() {
        return new XmlManifestCiReader(this.element);
    }

    public static class XmlManifestCiReader
    implements ManifestReader.ManifestCiReader {
        private Element element;

        public XmlManifestCiReader(Element element) {
            this.element = element;
        }

        @Override
        public Type type() {
            return Type.valueOf((String)this.element.getName());
        }

        @Override
        public String name() {
            if (Strings.isBlank((String)this.element.getAttributeValue("name"))) {
                throw new ImporterException("Missing or empty required attribute 'name' for CI '%s' in XML Manifest", this.element.getName());
            }
            return this.element.getAttributeValue("name");
        }

        @Override
        public String file() {
            return this.element.getAttributeValue("file");
        }

        @Override
        public boolean hasProperty(String name) {
            return this.element.getChild(name) != null;
        }

        @Override
        public String propertyAsString(String name) {
            this.checkOneElement(name);
            return this.element.getChildTextTrim(name);
        }

        private void checkOneElement(String name) {
            XmlManifestReader.check(this.element.getChildren(name).size() == 1, "More than 1 element named '%s' found for CI '%s[%s]' in XML Manifest", new Object[]{name, this.element.getAttributeValue("name"), this.element.getName()});
        }

        @Override
        public String propertyAsCiRef(String name) {
            this.checkOneElement(name);
            return this.element.getChild(name).getAttributeValue("ref");
        }

        @Override
        public List<String> propertyAsStringCollection(String name) {
            this.checkOneElement(name);
            ArrayList strings = Lists.newArrayList();
            for (Element value : this.element.getChild(name).getChildren("value")) {
                strings.add(value.getTextTrim());
            }
            return strings;
        }

        @Override
        public List<String> propertyAsCiRefCollection(String name) {
            this.checkOneElement(name);
            ArrayList refs = Lists.newArrayList();
            for (Element ci : this.element.getChild(name).getChildren("ci")) {
                refs.add(ci.getAttributeValue("ref"));
            }
            return refs;
        }

        @Override
        public Map<String, String> propertyAsMapStringString(String name) {
            this.checkOneElement(name);
            HashMap map = Maps.newHashMap();
            for (Element entry : this.element.getChild(name).getChildren("entry")) {
                map.put(entry.getAttributeValue("key"), entry.getTextTrim());
            }
            return map;
        }

        @Override
        public List<ManifestReader.ManifestCiReader> propertyAsNestedCis(String name) {
            this.checkOneElement(name);
            List children = this.element.getChild(name).getChildren();
            return Lists.newArrayList((Iterable)Lists.transform((List)children, (Function)new Function<Element, ManifestReader.ManifestCiReader>(){

                public ManifestReader.ManifestCiReader apply(Element input) {
                    return new XmlManifestCiReader(input);
                }
            }));
        }
    }
}

