/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.swing;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.swing.TFileSystemView;
import de.schlichtherle.truezip.file.swing.TFileView;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

@DefaultAnnotation(value={NonNull.class})
public final class TFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 936528972682036204L;

    public TFileChooser() {
        this(null, null);
    }

    public TFileChooser(@CheckForNull TFile currentDirectory) {
        this(currentDirectory, null);
    }

    public TFileChooser(@CheckForNull TFileSystemView fileSystemView) {
        this(null, fileSystemView);
    }

    public TFileChooser(@CheckForNull TFile currentDirectory, @CheckForNull TFileSystemView fileSystemView) {
        super(currentDirectory, (FileSystemView)(null != fileSystemView ? fileSystemView : new TFileSystemView()));
        super.setFileView(new TFileView(super.getFileView()));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        super.setFileSystemView(new TFileSystemView());
    }

    @Override
    public TFile getCurrentDirectory() {
        return this.getFileSystemView().wrap(super.getCurrentDirectory());
    }

    @Override
    public TFileSystemView getFileSystemView() {
        return (TFileSystemView)super.getFileSystemView();
    }

    @Override
    public void setFileSystemView(FileSystemView fileSystemView) {
        if (null == fileSystemView) {
            throw new NullPointerException();
        }
        super.setFileSystemView((TFileSystemView)fileSystemView);
    }

    @Override
    @Nullable
    public TFile getSelectedFile() {
        return this.getFileSystemView().wrap(super.getSelectedFile());
    }

    @Nullable
    public TFile[] getSelectedFiles() {
        File[] files = super.getSelectedFiles();
        if (null == files) {
            return null;
        }
        TFileSystemView fsv = this.getFileSystemView();
        TFile[] results = new TFile[files.length];
        int i = files.length;
        while (0 <= --i) {
            results[i] = fsv.wrap(files[i]);
        }
        return results;
    }
}

