/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.spi.event;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.spi.event.AuditableDeployitEvent;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.List;

public abstract class CiBaseEvent
extends AuditableDeployitEvent {
    private List<ConfigurationItem> cis = Lists.newArrayList();

    public CiBaseEvent(String component, String message) {
        super(component, message);
    }

    public CiBaseEvent(String component, String message, List<ConfigurationItem> cis) {
        super(component, message);
        this.cis = cis;
    }

    protected static String format(List<ConfigurationItem> ciList) {
        StringBuilder sb = new StringBuilder();
        for (ConfigurationItem configurationItem : ciList) {
            sb.append(CiBaseEvent.format(configurationItem));
            sb.append(" ");
        }
        return sb.toString();
    }

    protected static String format(ConfigurationItem configurationItem) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(configurationItem.getId());
        sb.append("]");
        return sb.toString();
    }

    public List<ConfigurationItem> getCis() {
        return this.cis;
    }
}

