/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class DeployitOptions {
    @Option(name="-setup", usage="(Re-)run the setup for Deployit", required=false)
    private boolean doSetup = false;
    @Option(name="-reinitialize", usage="Reinitialize the repository, only useful with -setup", required=false)
    private boolean reinitialize = false;
    @Option(name="-recovery", usage="Attempts a recovery of your repository in case it is corrupted", required=false)
    private boolean recovery = false;
    @Option(name="-force", required=false)
    private boolean force;
    @Option(name="-setup-defaults", required=false, usage="Use the given file for defaults during setup")
    private String defaultsFile;
    @Option(name="-repository-keystore-password", required=false, usage="The password to open the repository-keystore.jceks file, if not given, Deployit will prompt you.")
    private String repositoryKeystorePassword;
    @Option(name="-help", required=false, usage="Prints this usage message")
    private boolean printUsage = false;

    public boolean isDoSetup() {
        return this.doSetup;
    }

    public void setDoSetup(boolean doSetup) {
        this.doSetup = doSetup;
    }

    public boolean isReinitialize() {
        return this.reinitialize;
    }

    public void setReinitialize(boolean reinitialize) {
        this.reinitialize = reinitialize;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    public String getDefaultsFile() {
        return this.defaultsFile;
    }

    public void setDefaultsFile(String defaultsFile) {
        this.defaultsFile = defaultsFile;
    }

    public String getRepositoryKeystorePassword() {
        return this.repositoryKeystorePassword;
    }

    public void setRepositoryKeystorePassword(String repositoryKeystorePassword) {
        this.repositoryKeystorePassword = repositoryKeystorePassword;
    }

    public boolean isRecovery() {
        return this.recovery;
    }

    public void setRecovery(boolean recovery) {
        this.recovery = recovery;
    }

    public static DeployitOptions parseCommandLine(String[] args) {
        DeployitOptions options = new DeployitOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                DeployitOptions.printUsage(parser, System.out);
                return null;
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            DeployitOptions.printUsage(parser, System.err);
            return null;
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        stream.println("java -cp deployit-server-<version>.jar [options...] com.xebialabs.deployit.Deployit arguments...");
        parser.printUsage((OutputStream)stream);
    }
}

