/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.powershell;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.powershell.BasePowerShellDeployed;
import com.xebialabs.deployit.plugin.powershell.PowerShellContainer;
import com.xebialabs.deployit.plugin.powershell.PowerShellStepUtils;
import com.xebialabs.deployit.plugin.powershell.PowerShellVarsConverter;
import com.xebialabs.deployit.plugin.remoting.scripts.ScriptUtils;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PowerShellStep
implements PreviewStep {
    private static final String BASE_RUNTIME_PATH = "powershell/runtime";
    private HostContainer container;
    Deployed<?, ?> deployed;
    private String scriptPath;
    private Map<String, Object> powerShellVars;
    private String description;
    private boolean uploadArtifactData = true;
    private List<String> classpathResources = Lists.newArrayList();
    private static Logger logger = LoggerFactory.getLogger(PowerShellStep.class);

    public PowerShellStep(HostContainer container, Deployed<?, ?> deployed, String scriptPath, Map<String, Object> powerShellVars, String description) {
        this.container = (HostContainer)Preconditions.checkNotNull((Object)container, (Object)"container is null");
        Preconditions.checkArgument((this.container.getHost().getOs() == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (Object)"PowerShell scripts can only be run on Windows hosts");
        this.deployed = deployed;
        this.scriptPath = (String)Preconditions.checkNotNull((Object)scriptPath, (Object)"scriptPath is null");
        this.powerShellVars = (Map)Preconditions.checkNotNull(powerShellVars, (Object)"powerShellVars is null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description is null");
    }

    public Preview getPreview() {
        return PowerShellStepUtils.previewPowerShellScript(this.getPowerShellScriptCallback(true));
    }

    protected StepExitCode doExecute(ExecutionContext ctx) throws Exception {
        return PowerShellStepUtils.executePowerShellScript(this.container, ctx, this.getPowerShellScriptCallback(false));
    }

    private PowerShellStepUtils.PowerShellScriptCallback getPowerShellScriptCallback(final boolean maskPasswords) {
        return new PowerShellStepUtils.PowerShellScriptCallback(){

            @Override
            public String getScriptPath() {
                return PowerShellStep.this.scriptPath;
            }

            @Override
            public String generateScript(OverthereConnection conn) {
                return PowerShellStep.this.doGenerateScript(conn, maskPasswords);
            }

            @Override
            public void uploadAdditionalResources(HostContainer container, ExecutionContext ctx, OverthereConnection conn) {
                PowerShellStep.this.doUploadClasspathResources(ctx, conn);
            }
        };
    }

    String doGenerateScript(OverthereConnection connection, boolean maskPasswords) {
        logger.debug("Starting generation of PowerShell script for step [{}]", (Object)this.getDescription());
        StringBuilder scriptBuilder = new StringBuilder();
        logger.debug("Appending runtime scripts");
        this.appendBaseRuntimeScript(scriptBuilder);
        logger.debug("Appending container runtime scripts");
        this.appendContainerRuntimeScripts(scriptBuilder);
        logger.debug("Appending container library scripts");
        this.appendContainerLibraryScripts(scriptBuilder);
        logger.debug("Appending deployed library scripts");
        this.appendDeployedLibraryScripts(scriptBuilder);
        logger.debug("Appending PowerShell vars");
        this.appendPowerShellVars(connection, scriptBuilder, maskPasswords);
        logger.debug("Appending script");
        this.appendScript(scriptBuilder);
        logger.debug("Replacing all LF's that are NOT preceded by a CR with CRLF.");
        String script = scriptBuilder.toString().replaceAll("(?<!\r)\n", "\r\n");
        logger.debug("Finished generation of PowerShell script.");
        return script;
    }

    private void appendBaseRuntimeScript(StringBuilder b) {
        ScriptUtils.appendScriptDir((String)BASE_RUNTIME_PATH, (StringBuilder)b);
    }

    private void appendContainerRuntimeScripts(StringBuilder b) {
        if (this.container.hasProperty("runtimePath")) {
            String runtimePath = (String)this.container.getProperty("runtimePath");
            ScriptUtils.appendScriptDir((String)runtimePath, (StringBuilder)b);
        }
    }

    private void appendContainerLibraryScripts(StringBuilder b) {
        if (this.container instanceof PowerShellContainer) {
            ScriptUtils.appendScripts(((PowerShellContainer)this.container).getLibraryScripts(), (StringBuilder)b);
        }
    }

    private void appendDeployedLibraryScripts(StringBuilder b) {
        if (this.deployed instanceof BasePowerShellDeployed) {
            ScriptUtils.appendScripts(((BasePowerShellDeployed)this.deployed).getLibraryScripts(), (StringBuilder)b);
        }
    }

    private void appendPowerShellVars(OverthereConnection connection, StringBuilder b, boolean maskPasswords) {
        b.append("# PowerShellVars\n");
        b.append(PowerShellVarsConverter.javaToPowerShell(connection, this.powerShellVars, this.uploadArtifactData, maskPasswords));
    }

    private void appendScript(StringBuilder b) {
        b.append(ScriptUtils.loadScript((String)this.scriptPath));
    }

    private void doUploadClasspathResources(ExecutionContext ctx, OverthereConnection conn) {
        for (String r : this.classpathResources) {
            int indexOfLastSlash = r.lastIndexOf(47);
            String filename = indexOfLastSlash < 0 ? r : r.substring(indexOfLastSlash + 1);
            OverthereFile target = conn.getTempFile(filename);
            logger.info("Uploading classpath resource [{}] to temporary file [{}].", (Object)r, (Object)target);
            OutputStream out = target.getOutputStream();
            try {
                URL resourceURL = Resources.getResource((String)r);
                Resources.copy((URL)resourceURL, (OutputStream)out);
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
            finally {
                Closeables.closeQuietly((Closeable)out);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setUploadArtifactData(boolean uploadArtifactData) {
        this.uploadArtifactData = uploadArtifactData;
    }

    public void setClasspathResources(List<String> classpathResources) {
        this.classpathResources = classpathResources;
    }
}

