/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.socket.ByteArrayIOEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ByteArrayIOPool
implements IOPool<ByteArrayIOEntry> {
    private static final String MOCK_ENTRY_NAME = "mock";
    private final int initialCapacity;
    private volatile int total;
    private volatile int active;

    public ByteArrayIOPool() {
        this(32);
    }

    public ByteArrayIOPool(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Negative initial capacity: " + initialCapacity);
        }
        this.initialCapacity = initialCapacity;
    }

    @Override
    public synchronized Entry allocate() {
        Entry entry = new Entry(this.total++);
        ++this.active;
        return entry;
    }

    @Override
    public void release(IOPool.Entry<ByteArrayIOEntry> entry) throws IOException {
        entry.release();
    }

    public int getSize() {
        return this.active;
    }

    @NotThreadSafe
    public final class Entry
    extends ByteArrayIOEntry
    implements IOPool.Entry<ByteArrayIOEntry> {
        private boolean released;

        private Entry(int i) {
            super(ByteArrayIOPool.MOCK_ENTRY_NAME + i, ByteArrayIOPool.this.initialCapacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws IOException {
            if (this.released) {
                throw new IllegalStateException("entry has already been released!");
            }
            this.released = true;
            ByteArrayIOPool byteArrayIOPool = ByteArrayIOPool.this;
            synchronized (byteArrayIOPool) {
                ByteArrayIOPool.this.active--;
            }
            this.setData(null);
        }
    }
}

