/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api.execution;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;

public enum TaskExecutionState2 {
    UNREGISTERED,
    PENDING,
    SCHEDULED,
    QUEUED,
    EXECUTING,
    FAILING,
    FAILED,
    STOPPING,
    STOPPED,
    ABORTING,
    ABORTED,
    EXECUTED,
    DONE,
    CANCELLED;


    public boolean isActive() {
        return this == EXECUTING || this == FAILING || this == STOPPING || this == ABORTING;
    }

    public boolean isFinal() {
        return this == DONE || this == CANCELLED;
    }

    public TaskExecutionState toTaskExecutionState() {
        switch (this) {
            case UNREGISTERED: {
                return TaskExecutionState.UNREGISTERED;
            }
            case PENDING: {
                return TaskExecutionState.PENDING;
            }
            case SCHEDULED: {
                return TaskExecutionState.QUEUED;
            }
            case QUEUED: {
                return TaskExecutionState.QUEUED;
            }
            case EXECUTING: {
                return TaskExecutionState.EXECUTING;
            }
            case FAILING: {
                return TaskExecutionState.EXECUTING;
            }
            case FAILED: {
                return TaskExecutionState.STOPPED;
            }
            case STOPPING: {
                return TaskExecutionState.EXECUTING;
            }
            case STOPPED: {
                return TaskExecutionState.STOPPED;
            }
            case ABORTING: {
                return TaskExecutionState.EXECUTING;
            }
            case ABORTED: {
                return TaskExecutionState.STOPPED;
            }
            case EXECUTED: {
                return TaskExecutionState.EXECUTED;
            }
            case DONE: {
                return TaskExecutionState.DONE;
            }
            case CANCELLED: {
                return TaskExecutionState.CANCELLED;
            }
        }
        throw new IllegalStateException(String.format("Cannot convert %s into a TaskExecutionState", new Object[]{this}));
    }
}

