/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeReaderContext {
    private static final ThreadLocal<NodeReaderContext> CONTEXT_HOLDER = new ThreadLocal<NodeReaderContext>(){

        @Override
        protected NodeReaderContext initialValue() {
            logger.trace("Creating new context");
            return new NodeReaderContext();
        }
    };
    private AtomicInteger references = new AtomicInteger(0);
    private Map<String, ConfigurationItem> context = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(NodeReaderContext.class);

    NodeReaderContext() {
    }

    public static NodeReaderContext get() {
        return CONTEXT_HOLDER.get();
    }

    boolean hasItem(String uuid) {
        return this.context.containsKey(uuid);
    }

    ConfigurationItem get(String uuid) {
        return this.context.get(uuid);
    }

    void put(String uuid, ConfigurationItem item) {
        this.context.put(uuid, item);
    }

    public NodeReaderContext hold() {
        logger.trace("Holding context current leases {}", (Object)this.references);
        this.references.incrementAndGet();
        return this;
    }

    public void release() {
        logger.trace("Releasing context current leases {}", (Object)this.references);
        if (this.references.decrementAndGet() <= 0) {
            logger.trace("Removing context with: {}", this.context);
            CONTEXT_HOLDER.remove();
        }
    }
}

