/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Upgrader {
    private static final String DEPLOYIT_COMPONENT = "deployit";
    private ApplicationContext context;
    private JcrTemplate jcrTemplate;
    private ListMultimap<String, Upgrade> upgradeBeans;
    private boolean questionAsked = false;
    private static final Logger logger = LoggerFactory.getLogger(Upgrader.class);

    @Autowired
    public Upgrader(ApplicationContext context, JcrTemplate jcrTemplate) {
        this.context = context;
        this.jcrTemplate = jcrTemplate;
    }

    @PostConstruct
    public void doUpgrade() {
        this.upgradeBeans = this.getUpgrades();
        Set registeredPlugins = PluginVersions.getRegisteredPlugins();
        this.upgradeComponent(DEPLOYIT_COMPONENT);
        for (String component : Iterables.concat((Iterable[])new Iterable[]{registeredPlugins})) {
            if (DEPLOYIT_COMPONENT.equals(component)) continue;
            this.upgradeComponent(component);
        }
    }

    void upgradeComponent(String component) {
        logger.debug("Checking component [{}] for upgrades", (Object)component);
        Version componentVersion = null;
        try {
            componentVersion = this.readVersionOfComponent(component);
        }
        catch (RuntimeException e) {
            logger.info("Component [{}] has an invalid version -- skipping upgrade", (Object)component);
            return;
        }
        logger.debug("Component [{}] has version [{}] in the Deployit repository", (Object)component, (Object)componentVersion);
        List<Upgrade> applicableUpgrades = this.filterUpgrades(Upgrader.ensureNotNull(this.upgradeBeans.get((Object)component)), componentVersion);
        if (!applicableUpgrades.isEmpty()) {
            Collections.sort(applicableUpgrades);
            logger.info("Checked component [{}] which is at version [{}] -> Found upgrades to run: {}", new Object[]{component, componentVersion, applicableUpgrades});
            if (!this.questionAsked) {
                System.out.println("*** WARNING ***");
                System.out.println("We detected that we need to upgrade your Deployit repository");
                System.out.println("Before continuing we suggest you backup your Deployit repository in case the upgrade fails.");
                System.out.println("Please ensure you have 'INFO' level logging configured.");
                System.out.print("Please enter 'yes' if you want to continue [no]: ");
                String response = this.read();
                if (!"yes".equalsIgnoreCase(response)) {
                    logger.error("Did not receive an affirmative response on running upgrades, shutting down.");
                    EventBusHolder.publish(new ShutdownEvent());
                    return;
                }
                this.questionAsked = true;
            }
            this.applyUpgrades(applicableUpgrades);
        } else if (componentVersion.equals((Object)Version.valueOf((String)component, (String)"0.0.0"))) {
            Version currentPluginVersion = Version.valueOf((String)component, (String)PluginVersions.getVersionFor((String)component));
            logger.info("Registering previous unregistered version: [{}]", (Object)currentPluginVersion);
            this.storeVersionOfComponent(currentPluginVersion);
        }
    }

    void storeVersionOfComponent(final Version version) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws RepositoryException {
                Node node = Upgrader.this.getVersionsNode(session);
                node.setProperty(version.getComponent(), version.getVersion());
                session.save();
                return null;
            }
        });
    }

    Version readVersionOfComponent(final String component) {
        return this.jcrTemplate.execute(new JcrCallback<Version>(){

            @Override
            public Version doInJcr(Session session) throws RepositoryException {
                Node node = Upgrader.this.getVersionsNode(session);
                if (node.hasProperty(component)) {
                    Property versionProp = node.getProperty(component);
                    return Version.valueOf((String)component, (String)versionProp.getString());
                }
                return Version.valueOf((String)component, (String)"0.0.0");
            }
        });
    }

    private Node getVersionsNode(Session session) throws RepositoryException {
        try {
            return session.getNode("/$configuration/versions");
        }
        catch (PathNotFoundException pnfe) {
            return session.getRootNode().addNode("$configuration/versions");
        }
    }

    private void applyUpgrades(List<Upgrade> applicableUpgrades) {
        final ImmutableListMultimap versionToUpgradeMap = Multimaps.index(applicableUpgrades, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade input) {
                return input.upgradeVersion();
            }
        });
        ArrayList versions = Lists.newArrayList((Iterable)Lists.transform(applicableUpgrades, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade input) {
                return input.upgradeVersion();
            }
        }));
        Collections.sort(versions);
        for (final Version version : versions) {
            logger.info("Upgrading to version [{}]", (Object)version);
            this.jcrTemplate.execute(new JcrCallback<Object>(){

                @Override
                public Object doInJcr(Session session) throws RepositoryException {
                    for (Upgrade applicableUpgrade : versionToUpgradeMap.get((Object)version)) {
                        if (applicableUpgrade.doUpgrade((RawRepository)new RawRepositoryImpl(session))) continue;
                        throw new UpgradeException("Could not perform upgrade %s to upgrade to %s", new Object[]{applicableUpgrade.getClass(), applicableUpgrade.upgradeVersion()});
                    }
                    session.save();
                    return null;
                }
            });
            this.storeVersionOfComponent(version);
        }
    }

    private List<Upgrade> filterUpgrades(Collection<Upgrade> upgradeBeans, final Version repoVersion) {
        if (repoVersion.getVersion().equals("0.0.0")) {
            return Lists.newArrayList();
        }
        ArrayList applicableUpgrades = Lists.newArrayList((Iterable)Collections2.filter(upgradeBeans, (Predicate)new Predicate<Upgrade>(){

            public boolean apply(Upgrade input) {
                return input.shouldBeApplied(repoVersion);
            }
        }));
        Collections.sort(applicableUpgrades);
        return applicableUpgrades;
    }

    protected ListMultimap<String, Upgrade> getUpgrades() {
        Set upgradeClasses = Scannit.getInstance().getSubTypesOf(Upgrade.class);
        logger.debug("Found the following upgraders: [{}]", (Object)upgradeClasses);
        return Multimaps.index((Iterable)Collections2.transform((Collection)upgradeClasses, (Function)new Function<Class<? extends Upgrade>, Upgrade>(){

            public Upgrade apply(Class<? extends Upgrade> input) {
                return (Upgrade)Upgrader.this.context.getAutowireCapableBeanFactory().createBean(input);
            }
        }), (Function)new Function<Upgrade, String>(){

            public String apply(Upgrade input) {
                return input.upgradeVersion().getComponent();
            }
        });
    }

    protected String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                return line.trim();
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> List<T> ensureNotNull(List<T> list) {
        return list == null ? Lists.newArrayList() : list;
    }
}

