/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.RedoLog;
import org.apache.jackrabbit.core.query.lucene.directory.IndexInputStream;
import org.apache.jackrabbit.core.query.lucene.directory.IndexOutputStream;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRedoLog
implements RedoLog {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedoLog.class);
    static final String REDO_LOG = "redo.log";
    static final String REDO_LOG_PREFIX = "redo_";
    static final String DOT_LOG = ".log";
    private final ActionCollector ENTRY_COUNTER = new ActionCollector(){

        @Override
        public void collect(MultiIndex.Action a) {
            DefaultRedoLog.this.entryCount++;
        }
    };
    private final Directory dir;
    private final String fileName;
    private int entryCount = 0;
    private Writer out;

    private DefaultRedoLog(Directory dir, String fileName) throws IOException {
        this.dir = dir;
        this.fileName = fileName;
        this.read(this.ENTRY_COUNTER);
    }

    static RedoLog create(Directory dir, long generation) throws IOException {
        String fileName = generation == 0L ? REDO_LOG : REDO_LOG_PREFIX + Long.toString(generation, 36) + DOT_LOG;
        return new DefaultRedoLog(dir, fileName);
    }

    @Override
    public boolean hasEntries() {
        return this.entryCount > 0;
    }

    @Override
    public int getSize() {
        return this.entryCount;
    }

    @Override
    public List<MultiIndex.Action> getActions() throws IOException {
        final ArrayList<MultiIndex.Action> actions = new ArrayList<MultiIndex.Action>();
        this.read(new ActionCollector(){

            @Override
            public void collect(MultiIndex.Action a) {
                actions.add(a);
            }
        });
        return actions;
    }

    @Override
    public void append(MultiIndex.Action action) throws IOException {
        this.initOut();
        this.out.write(action.toString() + "\n");
        ++this.entryCount;
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            IndexOutputStream os = new IndexOutputStream(this.dir.createOutput(this.fileName));
            this.out = new BufferedWriter(new OutputStreamWriter(os));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(ActionCollector collector) throws IOException {
        if (!this.dir.fileExists(this.fileName)) {
            return;
        }
        IndexInputStream in = new IndexInputStream(this.dir.openInput(this.fileName));
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                try {
                    collector.collect(MultiIndex.Action.fromString(line));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Malformed redo entry: " + e.getMessage());
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.warn("Exception while closing redo log: " + e.toString());
                }
            }
        }
    }

    static interface ActionCollector {
        public void collect(MultiIndex.Action var1);
    }
}

