/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.api.ConfigurationService;
import com.xebialabs.deployit.core.api.dto.LicenseDto;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.v1.License;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ConfigurationResource
implements ConfigurationService {
    private final ServerConfiguration config;
    private final LicenseService licenseService;

    @Autowired
    public ConfigurationResource(ServerConfiguration config, LicenseService licenseService) {
        this.config = config;
        this.licenseService = licenseService;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("client.session.timeout.minutes", Integer.toString(this.config.getClientSessionTimeoutMinutes()));
        properties.put("client.session.remember.enabled", Boolean.toString(this.config.isClientSessionRememberEnabled()));
        return properties;
    }

    public LicenseDto getLicenseInfo() {
        License license = this.licenseService.getLicense();
        return new LicenseDto(license.getLicensedTo(), license.getContact(), License.LICENSE_DATE_FORMAT.print((ReadablePartial)license.getExpiresAfter()));
    }
}

