/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.packager;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.packager.CiNameCache;
import com.xebialabs.deployit.packager.ManifestWriter;
import com.xebialabs.deployit.packager.ManifestWriterDriver;
import com.xebialabs.deployit.packager.truezip.TFiles;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarPackager {
    private final CiNameCache cache = new CiNameCache();
    private ManifestWriterDriver manifestDriver;
    private static final Logger logger = LoggerFactory.getLogger(DarPackager.class);

    public DarPackager(ManifestWriter writer) {
        this.manifestDriver = new ManifestWriterDriver(this.cache, writer);
    }

    public TFile buildPackage(Version version, String targetDir) {
        String darName = this.darName(version);
        TFile darPackage = new TFile(targetDir, darName);
        try {
            this.manifestDriver.writeToPackage(version, darPackage);
            this.writeArtifactsToPackage((ConfigurationItem)version, darPackage);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            try {
                TFile.umount((TFile)darPackage);
            }
            catch (FsSyncException e) {
                logger.warn("Couldn't cleanly umount the dar package {}", (Object)darPackage);
            }
        }
        return darPackage;
    }

    private void writeArtifactsToPackage(ConfigurationItem ci, TFile darPackage) {
        OverthereFile sourceFile;
        if (ci instanceof FolderArtifact) {
            sourceFile = ((Artifact)ci).getFile();
            logger.debug("Writing {} to package {}", (Object)sourceFile, (Object)darPackage);
            TFile targetFolder = new TFile((File)darPackage, CiNameCache.id(this.cache.lookup(ci), sourceFile.getName()));
            targetFolder.mkdirs();
            this.copyFolder(sourceFile, targetFolder);
        } else if (ci instanceof Artifact) {
            sourceFile = ((Artifact)ci).getFile();
            logger.debug("Writing {} to package {}", (Object)sourceFile, (Object)darPackage);
            TFile targetFile = new TFile((File)darPackage, CiNameCache.id(this.cache.lookup(ci), sourceFile.getName()), TArchiveDetector.NULL);
            this.copyFile(sourceFile, targetFile);
        }
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (!pd.isAsContainment() || !EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.SET_OF_CI).contains(pd.getKind())) continue;
            Collection cis = (Collection)pd.get(ci);
            if (cis == null) {
                logger.warn("{}: {}.{} (as-containment, kind {}) should not be null", new Object[]{ci.getId(), ci.getType(), pd.getName(), pd.getKind()});
                continue;
            }
            for (ConfigurationItem c : cis) {
                this.writeArtifactsToPackage(c, darPackage);
            }
        }
    }

    private void copyFolder(OverthereFile sourceFile, TFile targetFolder) {
        for (OverthereFile overthereFile : sourceFile.listFiles()) {
            if (overthereFile.isFile()) {
                this.copyFile(overthereFile, new TFile((File)targetFolder, overthereFile.getName(), TArchiveDetector.NULL));
                continue;
            }
            if (!overthereFile.isDirectory()) continue;
            TFile targetFolder1 = new TFile((File)targetFolder, overthereFile.getName());
            targetFolder1.mkdirs();
            this.copyFolder(overthereFile, targetFolder1);
        }
    }

    private void copyFile(OverthereFile sourceFile, TFile targetFile) {
        InputStream inputStream = sourceFile.getInputStream();
        try {
            ByteStreams.copy((InputStream)inputStream, TFiles.newOutputSupplier(targetFile));
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    private String darName(Version version) {
        return String.format("%s-%s.dar", version.getApplication().getName(), version.getVersion());
    }
}

