/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.rof.BufferedReadOnlyFile;
import de.schlichtherle.truezip.rof.IntervalReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import de.schlichtherle.truezip.util.Maps;
import de.schlichtherle.truezip.util.Pool;
import de.schlichtherle.truezip.zip.CRC32Exception;
import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.CountingInputStream;
import de.schlichtherle.truezip.zip.Crc32CheckingInputStream;
import de.schlichtherle.truezip.zip.DummyByteInputStream;
import de.schlichtherle.truezip.zip.IrregularOffsetMapper;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.OffsetMapper;
import de.schlichtherle.truezip.zip.SingleReadOnlyFilePool;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import de.schlichtherle.truezip.zip.WinZipAesEntryReadOnlyFile;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.WinZipAesUtils;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipEntryFactory;
import de.schlichtherle.truezip.zip.ZipFileParameters;
import de.schlichtherle.truezip.zip.ZipInflaterInputStream;
import de.schlichtherle.truezip.zip.ZipParametersUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class RawZipFile<E extends ZipEntry>
implements Iterable<E>,
Closeable {
    private static final int LFH_FILE_NAME_LENGTH_OFF = 26;
    public static final Charset DEFAULT_CHARSET = Constants.DEFAULT_CHARSET;
    @CheckForNull
    private ReadOnlyFile rof;
    private long length;
    private long preamble;
    private long postamble;
    private final ZipEntryFactory<E> param;
    private Charset charset;
    @CheckForNull
    private byte[] comment;
    private Map<String, E> entries;
    private OffsetMapper mapper = new OffsetMapper();
    private int open;

    protected RawZipFile(ReadOnlyFile zip, ZipFileParameters<E> param) throws IOException {
        this(new SingleReadOnlyFilePool(zip), param);
    }

    RawZipFile(Pool<ReadOnlyFile, IOException> source, ZipFileParameters<E> param) throws IOException {
        if (null == param) {
            throw new NullPointerException();
        }
        ReadOnlyFile rof = (ReadOnlyFile)source.allocate();
        try {
            this.rof = rof;
            this.length = rof.length();
            this.param = param;
            this.charset = param.getCharset();
            SafeBufferedReadOnlyFile brof = new SafeBufferedReadOnlyFile(rof, this.length);
            if (!param.getPreambled()) {
                this.assertZipFileSignature((ReadOnlyFile)brof);
            }
            int numEntries = this.findCentralDirectory((ReadOnlyFile)brof, param.getPostambled());
            this.mountCentralDirectory((ReadOnlyFile)brof, numEntries);
            if (this.preamble + this.postamble >= this.length) {
                assert (0 == numEntries);
                if (param.getPreambled()) {
                    this.assertZipFileSignature((ReadOnlyFile)brof);
                }
            }
        }
        catch (IOException ex) {
            source.release((Object)rof);
            throw ex;
        }
        assert (null != this.rof);
        assert (null != this.charset);
        assert (null != this.entries);
        assert (null != this.mapper);
    }

    private void assertZipFileSignature(ReadOnlyFile rof) throws IOException {
        byte[] sig = new byte[4];
        rof.seek(this.preamble);
        rof.readFully(sig);
        long signature = LittleEndian.readUInt(sig, 0);
        if (67324752L != signature && 101075792L != signature && 101010256L != signature) {
            throw new ZipException("A valid ZIP file must start with a Local File Header or a (ZIP64) End Of Central Directory Record iff it's empty!");
        }
    }

    private int findCentralDirectory(ReadOnlyFile rof, boolean postambled) throws IOException {
        byte[] sig = new byte[4];
        long max = this.length - 22L;
        long min = !postambled && max >= 65535L ? max - 65535L : 0L;
        for (long eocdrOff = max; eocdrOff >= min; --eocdrOff) {
            long cdEntries;
            block11: {
                rof.seek(eocdrOff);
                rof.readFully(sig);
                if (101010256L != LittleEndian.readUInt(sig, 0)) continue;
                byte[] eocdr = new byte[22 - sig.length];
                rof.readFully(eocdr);
                int off = 0;
                long diskNo = LittleEndian.readUShort(eocdr, off);
                long cdDiskNo = LittleEndian.readUShort(eocdr, off += 2);
                long cdEntriesDisk = LittleEndian.readUShort(eocdr, off += 2);
                cdEntries = LittleEndian.readUShort(eocdr, off += 2);
                off += 2;
                if (0L != diskNo || 0L != cdDiskNo || cdEntriesDisk != cdEntries) {
                    throw new ZipException("ZIP file spanning/splitting is not supported!");
                }
                long cdSize = LittleEndian.readUInt(eocdr, off);
                long cdOffset = LittleEndian.readUInt(eocdr, off += 4);
                int commentLen = LittleEndian.readUShort(eocdr, off += 4);
                if (0 < commentLen) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    this.comment = comment;
                }
                this.preamble = eocdrOff;
                this.postamble = this.length - rof.getFilePointer();
                try {
                    rof.seek(eocdrOff - 20L);
                    byte[] zip64eocdl = new byte[20];
                    rof.readFully(zip64eocdl);
                    if (117853008L != LittleEndian.readUInt(zip64eocdl, 0)) {
                        throw new IOException("No ZIP64 End Of Central Directory Locator signature found!");
                    }
                    off = 4;
                    long zip64eocdrDisk = LittleEndian.readUInt(zip64eocdl, off);
                    long zip64eocdrOff = LittleEndian.readLong(zip64eocdl, off += 4);
                    long totalDisks = LittleEndian.readUInt(zip64eocdl, off += 8);
                    if (0L != zip64eocdrDisk || 1L != totalDisks) {
                        throw new ZipException("ZIP file spanning/splitting is not supported!");
                    }
                    byte[] zip64eocdr = new byte[56];
                    rof.seek(zip64eocdrOff);
                    rof.readFully(zip64eocdr);
                    off = 0;
                    if (101075792L != LittleEndian.readUInt(zip64eocdr, off)) {
                        throw new ZipException("No ZIP64 End Of Central Directory Record signature found!");
                    }
                    off += 4;
                    off += 8;
                    off += 2;
                    diskNo = LittleEndian.readUInt(zip64eocdr, off += 2);
                    cdDiskNo = LittleEndian.readUInt(zip64eocdr, off += 4);
                    cdEntriesDisk = LittleEndian.readLong(zip64eocdr, off += 4);
                    cdEntries = LittleEndian.readLong(zip64eocdr, off += 8);
                    off += 8;
                    if (0L != diskNo || 0L != cdDiskNo || cdEntriesDisk != cdEntries) {
                        throw new ZipException("ZIP file spanning/splitting is not supported!");
                    }
                    if (cdEntries < 0L || Integer.MAX_VALUE < cdEntries) {
                        throw new ZipException("Total Number Of Entries In The Central Directory out of range!");
                    }
                    cdSize = LittleEndian.readLong(zip64eocdr, off);
                    cdOffset = LittleEndian.readLong(zip64eocdr, off += 8);
                    rof.seek(cdOffset);
                    this.preamble = zip64eocdrOff;
                }
                catch (ZipException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    long start = eocdrOff - cdSize;
                    rof.seek(start);
                    if (0L == (start -= cdOffset)) break block11;
                    this.mapper = new IrregularOffsetMapper(start);
                }
            }
            return (int)cdEntries;
        }
        this.preamble = min;
        this.postamble = this.length - min;
        return 0;
    }

    private void mountCentralDirectory(ReadOnlyFile rof, int numEntries) throws IOException {
        LinkedHashMap<String, E> entries = new LinkedHashMap<String, E>(Math.max(Maps.initialCapacity((int)numEntries), 16));
        byte[] cfh = new byte[46];
        while (true) {
            boolean utf8;
            rof.readFully(cfh, 0, 4);
            if (33639248L != LittleEndian.readUInt(cfh, 0)) break;
            rof.readFully(cfh, 4, 42);
            int gpbf = LittleEndian.readUShort(cfh, 8);
            int nameLen = LittleEndian.readUShort(cfh, 28);
            byte[] name = new byte[nameLen];
            rof.readFully(name);
            boolean bl = utf8 = 0 != (gpbf & ZipEntry.GPBF_UTF8);
            if (utf8) {
                this.charset = Constants.UTF8;
            }
            E entry = this.param.newEntry(this.decode(name));
            try {
                int off = 0;
                ((ZipEntry)entry).setRawPlatform(LittleEndian.readUShort(cfh, off += 4) >> 8);
                off += 2;
                off += 2;
                ((ZipEntry)entry).setGeneralPurposeBitFlags(gpbf);
                ((ZipEntry)entry).setRawMethod(LittleEndian.readUShort(cfh, off += 2));
                ((ZipEntry)entry).setRawTime(LittleEndian.readUInt(cfh, off += 2));
                ((ZipEntry)entry).setRawCrc(LittleEndian.readUInt(cfh, off += 4));
                ((ZipEntry)entry).setRawCompressedSize(LittleEndian.readUInt(cfh, off += 4));
                ((ZipEntry)entry).setRawSize(LittleEndian.readUInt(cfh, off += 4));
                off += 4;
                int extraLen = LittleEndian.readUShort(cfh, off += 2);
                int commentLen = LittleEndian.readUShort(cfh, off += 2);
                off += 2;
                off += 2;
                ((ZipEntry)entry).setRawExternalAttributes(LittleEndian.readUInt(cfh, off += 2));
                long lfhOff = LittleEndian.readUInt(cfh, off += 4);
                ((ZipEntry)entry).setRawOffset(lfhOff);
                if (0 < extraLen) {
                    byte[] extra = new byte[extraLen];
                    rof.readFully(extra);
                    ((ZipEntry)entry).setRawExtraFields(extra);
                }
                if (0 < commentLen) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    ((ZipEntry)entry).setRawComment(this.decode(comment));
                }
                if ((lfhOff = this.mapper.map(((ZipEntry)entry).getOffset())) < this.preamble) {
                    this.preamble = lfhOff;
                }
            }
            catch (RuntimeException cause) {
                ZipException ex = new ZipException(((ZipEntry)entry).getName() + " (invalid ZIP entry)");
                ex.initCause(cause);
                throw ex;
            }
            entries.put(((ZipEntry)entry).getName(), entry);
            --numEntries;
        }
        if (0 != numEntries % 65536) {
            throw new ZipException("Expected " + Math.abs(numEntries) + (numEntries > 0 ? " more" : " less") + " entries in the Central Directory!");
        }
        this.entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void recoverLostEntries() throws IOException {
        this.assertOpen();
        if (!RawZipFile.$assertionsDisabled && null == this.rof) {
            throw new AssertionError();
        }
        rof = new SafeBufferedReadOnlyFile(this.rof, this.length);
        while (0L < this.postamble) {
            fp = this.length - this.postamble;
            rof.seek(fp);
            lfh = new byte[30];
            rof.readFully(lfh, 0, 4);
            sig = LittleEndian.readUInt(lfh, 0);
            if (67324752L != sig) {
                throw new ZipException("Expected Local File Header signature 0x" + Long.toHexString(67324752L) + ", but is 0x" + Long.toHexString(sig) + "!");
            }
            rof.readFully(lfh, 4, 26);
            gpbf = LittleEndian.readUShort(lfh, 6);
            nameLen = LittleEndian.readUShort(lfh, 26);
            name = new byte[nameLen];
            rof.readFully(name);
            v0 = utf8 = 0 != (gpbf & ZipEntry.GPBF_UTF8);
            if (utf8) {
                this.charset = Constants.UTF8;
            }
            entry = this.param.newEntry(this.decode(name));
            off = 0;
            off += 4;
            off += 2;
            entry.setGeneralPurposeBitFlags(gpbf);
            entry.setRawMethod(LittleEndian.readUShort(lfh, off += 2));
            entry.setRawTime(LittleEndian.readUInt(lfh, off += 2));
            entry.setRawCrc(LittleEndian.readUInt(lfh, off += 4));
            entry.setRawCompressedSize(LittleEndian.readUInt(lfh, off += 4));
            entry.setRawSize(LittleEndian.readUInt(lfh, off += 4));
            off += 4;
            extraLen = LittleEndian.readUShort(lfh, off += 2);
            entry.setRawOffset(this.mapper.unmap(fp));
            if (0 < extraLen) {
                extra = new byte[extraLen];
                rof.readFully(extra);
                entry.setRawExtraFields(extra);
            }
            if (entry.getGeneralPurposeBitFlag(ZipEntry.GPBF_DATA_DESCRIPTOR)) {
                start = fp = rof.getFilePointer();
                erof /* !! */  = new IntervalReadOnlyFile((ReadOnlyFile)rof, fp, this.length - fp);
                field = null;
                method = entry.getMethod();
                if (entry.isEncrypted()) {
                    if (99 != method) {
                        throw new ZipException(entry.getName() + " (encrypted compression method " + method + " is not supported)");
                    }
                    erof /* !! */  = new WinZipAesEntryReadOnlyFile((ReadOnlyFile)erof /* !! */ , new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), (ZipEntry)entry));
                    field = (WinZipAesEntryExtraField)entry.getExtraField(39169);
                    method = field.getMethod();
                }
                bufSize = RawZipFile.getBufferSize(entry);
                din = null;
                switch (method) {
                    case 8: {
                        in = new ZipInflaterInputStream(new DummyByteInputStream((ReadOnlyFile)erof /* !! */ ), bufSize);
                        break;
                    }
                    case 12: {
                        din = new CountingInputStream((InputStream)new ReadOnlyFileInputStream((ReadOnlyFile)erof /* !! */ ));
                        in = new BZip2CompressorInputStream((InputStream)din);
                        break;
                    }
                    default: {
                        throw new ZipException(entry.getName() + " (compression method " + method + " is not supported)");
                    }
                }
                cin = new CheckedInputStream(in, new CRC32());
                try {
                    entry.setRawSize(cin.skip(0x7FFFFFFFFFFFFFFFL));
                    if (null != field && field.getVendorVersion() == 2) {
                        entry.setRawCrc(0L);
                    } else {
                        entry.setRawCrc(cin.getChecksum().getValue());
                    }
                    switch (method) {
                        case 8: {
                            inf = in.getInflater();
                            if (!RawZipFile.$assertionsDisabled && !inf.finished()) {
                                throw new AssertionError();
                            }
                            fp += inf.getBytesRead();
                            ** break;
lbl75:
                            // 1 sources

                            break;
                        }
                        case 12: {
                            fp += din.getBytesRead();
                            ** break;
lbl79:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                finally {
                    cin.close();
                }
                if (null != field) {
                    fp += (long)WinZipAesUtils.overhead(field.getKeyStrength());
                }
                entry.setRawCompressedSize(fp - start);
                dd = new byte[entry.isZip64ExtensionsRequired() != false ? 20 : 12];
                rof.seek(fp);
                rof.readFully(dd, 0, 4);
                crc = LittleEndian.readUInt(dd, 0);
                if (134695760L == crc) {
                    rof.readFully(dd);
                } else {
                    rof.readFully(dd, 4, dd.length - 4);
                }
                crc = LittleEndian.readUInt(dd, 0);
                if (entry.isZip64ExtensionsRequired()) {
                    csize = LittleEndian.readLong(dd, 4);
                    size = LittleEndian.readLong(dd, 12);
                } else {
                    csize = LittleEndian.readUInt(dd, 4);
                    size = LittleEndian.readUInt(dd, 8);
                }
                if (entry.getCrc() != crc) {
                    throw new CRC32Exception(entry.getName(), entry.getCrc(), crc);
                }
                if (entry.getCompressedSize() != csize) {
                    throw new ZipException(entry.getName() + " (invalid compressed size in Data Descriptor)");
                }
                if (entry.getSize() != size) {
                    throw new ZipException(entry.getName() + " (invalid uncompressed size in Data Descriptor)");
                }
            } else {
                rof.seek((fp += entry.getCompressedSize()) - 1L);
                if (fp > this.length || -1 == rof.read()) {
                    throw new ZipException(entry.getName() + " (truncated ZIP entry)");
                }
            }
            this.postamble = this.length - rof.getFilePointer();
            this.entries.put(entry.getName(), entry);
        }
    }

    final Map<String, E> getRawEntries() {
        return this.entries;
    }

    private String decode(byte[] bytes) {
        return new String(bytes, this.charset);
    }

    @CheckForNull
    final byte[] getRawComment() {
        return this.comment;
    }

    @Nullable
    public String getComment() {
        byte[] comment = this.comment;
        return null == comment ? null : this.decode(comment);
    }

    public boolean busy() {
        return 0 < this.open;
    }

    public Charset getRawCharset() {
        return this.charset;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.values().iterator();
    }

    public E getEntry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    public long length() {
        return this.length;
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        this.assertOpen();
        return new ReadOnlyFileInputStream((ReadOnlyFile)new EntryReadOnlyFile(0L, this.preamble));
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        this.assertOpen();
        return new ReadOnlyFileInputStream((ReadOnlyFile)new EntryReadOnlyFile(this.length - this.postamble, this.postamble));
    }

    final OffsetMapper getOffsetMapper() {
        return this.mapper;
    }

    public boolean offsetsConsiderPreamble() {
        assert (this.mapper != null);
        return 0L == this.mapper.map(0L);
    }

    @CheckForNull
    protected abstract ZipCryptoParameters getCryptoParameters();

    @Nullable
    public final InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, null, true);
    }

    @Nullable
    public final InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), null, true);
    }

    @Nullable
    public final InputStream getCheckedInputStream(String name) throws IOException {
        return this.getInputStream(name, true, true);
    }

    @Nullable
    public final InputStream getCheckedInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), true, true);
    }

    @Nullable
    protected InputStream getInputStream(String name, @CheckForNull Boolean check, boolean process) throws IOException {
        Object in;
        this.assertOpen();
        if (name == null) {
            throw new NullPointerException();
        }
        ZipEntry entry = (ZipEntry)this.entries.get(name);
        if (entry == null) {
            return null;
        }
        long fp = entry.getOffset();
        assert (-1L != fp);
        fp = this.mapper.map(fp);
        ReadOnlyFile rof = this.rof;
        assert (null != rof);
        rof.seek(fp);
        byte[] lfh = new byte[30];
        rof.readFully(lfh);
        long sig = LittleEndian.readUInt(lfh, 0);
        if (67324752L != sig) {
            throw new ZipException(name + " (expected Local File Header signature 0x" + Long.toHexString(67324752L) + ", but is 0x" + Long.toHexString(sig) + ")");
        }
        Object erof = new EntryReadOnlyFile(fp += (long)(30 + LittleEndian.readUShort(lfh, 26) + LittleEndian.readUShort(lfh, 28)), entry.getCompressedSize());
        if (!process) {
            assert (-1L != entry.getCrc());
            return new ReadOnlyFileInputStream((ReadOnlyFile)erof);
        }
        if (null == check) {
            check = entry.isEncrypted();
        }
        int method = entry.getMethod();
        if (entry.isEncrypted()) {
            if (99 != method) {
                throw new ZipException(name + " (encrypted compression method " + method + " is not supported)");
            }
            WinZipAesEntryReadOnlyFile eerof = new WinZipAesEntryReadOnlyFile((ReadOnlyFile)erof, new WinZipAesEntryParameters(ZipParametersUtils.parameters(WinZipAesParameters.class, this.getCryptoParameters()), entry));
            erof = eerof;
            if (check.booleanValue()) {
                eerof.authenticate();
                check = false;
            }
            WinZipAesEntryExtraField field = (WinZipAesEntryExtraField)entry.getExtraField(39169);
            method = field.getMethod();
        }
        if (check.booleanValue()) {
            long localCrc;
            if (entry.getGeneralPurposeBitFlag(ZipEntry.GPBF_DATA_DESCRIPTOR)) {
                byte[] dd = new byte[8];
                rof.seek(fp + entry.getCompressedSize());
                rof.readFully(dd);
                localCrc = LittleEndian.readUInt(dd, 0);
                if (134695760L == localCrc) {
                    localCrc = LittleEndian.readUInt(dd, 4);
                }
            } else {
                localCrc = LittleEndian.readUInt(lfh, 14);
            }
            if (entry.getCrc() != localCrc) {
                throw new CRC32Exception(name, entry.getCrc(), localCrc);
            }
        }
        int bufSize = RawZipFile.getBufferSize(entry);
        switch (method) {
            case 0: {
                in = new ReadOnlyFileInputStream((ReadOnlyFile)erof);
                break;
            }
            case 8: {
                in = new ZipInflaterInputStream(new DummyByteInputStream((ReadOnlyFile)erof), bufSize);
                break;
            }
            case 12: {
                in = new BZip2CompressorInputStream((InputStream)new ReadOnlyFileInputStream((ReadOnlyFile)erof));
                break;
            }
            default: {
                throw new ZipException(name + " (compression method " + method + " is not supported)");
            }
        }
        if (check.booleanValue()) {
            in = new Crc32CheckingInputStream((InputStream)in, entry, bufSize);
        }
        return in;
    }

    private static int getBufferSize(ZipEntry entry) {
        long size = entry.getSize();
        if (8192L < size) {
            size = 8192L;
        } else if (size < 1024L) {
            size = 1024L;
        }
        return (int)size;
    }

    final void assertOpen() throws ZipException {
        if (null == this.rof) {
            throw new ZipException("ZIP file closed!");
        }
    }

    @Override
    public void close() throws IOException {
        ReadOnlyFile rof = this.rof;
        if (null == rof) {
            return;
        }
        this.rof = null;
        rof.close();
    }

    private static final class SafeBufferedReadOnlyFile
    extends BufferedReadOnlyFile {
        final long length;

        public SafeBufferedReadOnlyFile(ReadOnlyFile rof, long length) throws IOException {
            super(rof);
            assert (length <= rof.length());
            this.length = length;
        }

        public long length() throws IOException {
            this.assertOpen();
            return this.length;
        }
    }

    private final class EntryReadOnlyFile
    extends IntervalReadOnlyFile {
        private boolean closed;

        EntryReadOnlyFile(long start, long length) throws IOException {
            super(RawZipFile.this.rof, start, length);
            assert (null != RawZipFile.this.rof);
            RawZipFile.this.open++;
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            RawZipFile.this.open--;
        }
    }
}

