package com.xebialabs.deployit.provision
package resolver

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.provision.resolver.placeholder.PlaceholderResolver
import com.xebialabs.deployit.service.replacement.{ConsolidatedDictionary, Dictionaries}

import scala.collection.convert.ImplicitConversions._
import scala.language.existentials

object ProvisionedResolver {

  def apply(provisionedBlueprint: DeployedApplication): ProvisionedResolver = apply(Dictionaries.of(provisionedBlueprint.getEnvironment)
    .withAdditionalEntries(provisionedBlueprint.getUnresolvedPlaceholdersWithValues).consolidate(), provisionedBlueprint)

  def apply(dictionary: ConsolidatedDictionary, provisionedBlueprint: DeployedApplication): ProvisionedResolver = new ProvisionedResolver(dictionary, provisionedBlueprint)

}

class ProvisionedResolver(dictionary: ConsolidatedDictionary, provisionedBlueprint: DeployedApplication) {
  private def placeholderResolver(provisioned: DeployedType): PlaceholderResolver = PlaceholderResolver(dictionary, Option(provisioned))

  def resolveProvisioned(provisioned: DeployedType): Unit = {
    implicit val resolver = placeholderResolver(provisioned)
    provisioned.setId(resolveValue(provisioned.getId))
    resolveProvisionedPropertyDescriptors(provisioned)
  }

  private def resolveProvisionedPropertyDescriptors(provisioned: DeployedType)(implicit resolver: PlaceholderResolver): Unit = {
    provisioned.getType.getDescriptor.getPropertyDescriptors.foreach(resolveProvisionedPropertyDescriptor(_, provisioned))
  }

  private def resolveProvisionedPropertyDescriptor(prop: PropertyDescriptor, provisioned: DeployedType)(implicit resolver: PlaceholderResolver): Unit = {
    if (prop.getReferencedType == null) {
      val value = provisioned.getProperty[AnyRef](prop.getName)
      if (value.nonEmpty) {
        provisioned.setProperty(prop.getName, resolver.resolve(value, Option(prop.getKind)))
      }
    }
  }

  def resolveValue(property: String)(implicit resolver: PlaceholderResolver): String = {
    resolver.resolve(property).asInstanceOf[String]
  }
}

