/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.auth.config;

import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005u4A!\u0003\u0006\u0001+!)\u0011\b\u0001C\u0001u!9Q\b\u0001b\u0001\n\u0013q\u0004BB#\u0001A\u0003%q\bC\u0004G\u0001\u0001\u0007I\u0011B$\t\u000fe\u0003\u0001\u0019!C\u00055\"1\u0001\r\u0001Q!\n!CQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001a\u0001\u0005\u0002\u0015\u0014\u0011\u0004T8hS:\fU\u000f\u001e5pe&T\u0018\r^5p]6\u000bg.Y4fe*\u00111\u0002D\u0001\u0007G>tg-[4\u000b\u00055q\u0011\u0001B1vi\"T!a\u0004\t\u0002\u0011adG-\u001a9m_fT!!\u0005\n\u0002\u0013a,'-[1mC\n\u001c(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005Yi3c\u0001\u0001\u0018?A\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0005Y\u0006twMC\u0001\u001d\u0003\u0011Q\u0017M^1\n\u0005yI\"AB(cU\u0016\u001cG\u000fE\u0002!S-j\u0011!\t\u0006\u0003E\r\nQ\"Y;uQ>\u0014\u0018N_1uS>t'B\u0001\u0013&\u0003!\u0019XmY;sSRL(B\u0001\u0014(\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\u0015\u0002\u0007=\u0014x-\u0003\u0002+C\t!\u0012)\u001e;i_JL'0\u0019;j_:l\u0015M\\1hKJ\u0004\"\u0001L\u0017\r\u0001\u0011)a\u0006\u0001b\u0001_\tY\"+Z9vKN$\u0018)\u001e;i_JL'0\u0019;j_:\u001cuN\u001c;fqR\f\"\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u000f9{G\u000f[5oOB\u0011\u0011gN\u0005\u0003qI\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q\t1\bE\u0002=\u0001-j\u0011AC\u0001\u0007Y><w-\u001a:\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0014\u0002\u000bMdg\r\u000e6\n\u0005\u0011\u000b%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001b]D\u0017\u000e^3mSN$XK\u001d7t+\u0005A\u0005cA%M\u001d6\t!J\u0003\u0002L7\u0005!Q\u000f^5m\u0013\ti%JA\u0002TKR\u0004\"a\u0014,\u000f\u0005A#\u0006CA)3\u001b\u0005\u0011&BA*\u0015\u0003\u0019a$o\\8u}%\u0011QKM\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002Ve\u0005\tr\u000f[5uK2L7\u000f^+sYN|F%Z9\u0015\u0005ms\u0006CA\u0019]\u0013\ti&G\u0001\u0003V]&$\bbB0\u0006\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014AD<iSR,G.[:u+Jd7\u000fI\u0001\u0011g\u0016$x\u000b[5uK2L7\u000f^+sYN$\"aW2\t\u000b\u0019;\u0001\u0019\u0001%\u0002\u000b\rDWmY6\u0015\u0007\u0019Lw\u000f\u0005\u0002!O&\u0011\u0001.\t\u0002\u0016\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8EK\u000eL7/[8o\u0011\u0015Q\u0007\u00021\u0001l\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:\u00042\u0001\\8r\u001b\u0005i'B\u00018K\u0003!1WO\\2uS>t\u0017B\u00019n\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\bC\u0001:v\u001b\u0005\u0019(B\u0001;$\u0003\u0011\u0019wN]3\n\u0005Y\u001c(AD!vi\",g\u000e^5dCRLwN\u001c\u0005\u0006q\"\u0001\raK\u0001\u0007_\nTWm\u0019;)\u0005!Q\bC\u0001\r|\u0013\ta\u0018D\u0001\u0005Pm\u0016\u0014(/\u001b3f\u0001")
public class LoginAuthorizationManager<RequestAuthorizationContext>
implements AuthorizationManager<RequestAuthorizationContext> {
    private final Logger logger = LoggerFactory.getLogger(LoginAuthorizationManager.class);
    private Set<String> whitelistUrls = new HashSet<String>();

    public void verify(Supplier<Authentication> authentication, RequestAuthorizationContext object) {
        super.verify(authentication, object);
    }

    private Logger logger() {
        return this.logger;
    }

    private Set<String> whitelistUrls() {
        return this.whitelistUrls;
    }

    private void whitelistUrls_$eq(Set<String> x$1) {
        this.whitelistUrls = x$1;
    }

    public void setWhitelistUrls(Set<String> whitelistUrls) {
        this.whitelistUrls_$eq(whitelistUrls);
    }

    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext object) {
        if (object instanceof FilterInvocation) {
            String requestUrl = ((FilterInvocation)object).getRequestUrl();
            if (this.whitelistUrls().contains(requestUrl)) {
                this.logger().debug("Endpoint [{}] is whitelisted", (Object)requestUrl);
                return new AuthorizationDecision(true);
            }
        }
        this.logger().debug("Checking authorization for [{}]", (Object)authentication.get());
        if (SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication.get(), new Permission[]{PlatformPermissions.LOGIN})) {
            this.logger().debug("User [{}] is authorized for login", (Object)authentication.get());
            return new AuthorizationDecision(true);
        }
        this.logger().error("User [{}] is not allowed to login to XL Deploy.", (Object)authentication.get());
        return new AuthorizationDecision(false);
    }
}

