package com.xebialabs.xldeploy.auth;

import com.xebialabs.deployit.security.authentication.BasicAuthWithRememberMeFilter;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;

public class DeployBasicAuthenticationFilter extends BasicAuthWithRememberMeFilter {
    public DeployBasicAuthenticationFilter(final AuthenticationManager authenticationManager, final AuthenticationEntryPoint authenticationEntryPoint) {
        super(authenticationManager, authenticationEntryPoint);
    }

    // Override is required due to change in spring-security
    // see, https://github.com/spring-projects/spring-security/commit/e0e6467d9b1203b38d152b40281265e0816af8be
    @Override
    protected boolean authenticationIsRequired(final String username) {
        // Only reauthenticate if username doesn't match SecurityContextHolder and user
        // isn't authenticated (see SEC-53)
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        if (existingAuth == null || !existingAuth.isAuthenticated()) {
            return true;
        }
        // Limit username comparison to providers which use usernames (ie UsernamePasswordAuthenticationToken) (see SEC-348)
        if (existingAuth instanceof UsernamePasswordAuthenticationToken && !existingAuth.getName().equals(username)) {
            return true;
        }
        return (existingAuth instanceof AnonymousAuthenticationToken);
    }
}
