/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.converters;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.dto.BannerInfo;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class BannerInfoJsonConverter {
    private static final String CONTENT = "content";
    private static final String KIND = "kind";

    public String toJson(BannerInfo bannerInfo) {
        JsonWriter writer = new JsonWriter();
        this.toJson(bannerInfo, writer);
        return writer.toString();
    }

    public void toJson(BannerInfo bannerInfo, JsonWriter writer) {
        writer.object();
        writer.key(KIND).value((Object)bannerInfo.getKind().name());
        writer.key(CONTENT).value((Object)bannerInfo.getContent());
        writer.endObject();
    }

    public BannerInfo toBannerInfo(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            Checks.checkArgument((boolean)json.has(KIND), (String)"Missing 'kind' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            Checks.checkArgument((boolean)json.has(CONTENT), (String)"Missing 'content' property in JSON:\n%s", (Object[])new Object[]{jsonString});
            BannerInfo.BannerKind kind = BannerInfo.BannerKind.fromValue((String)json.getString(KIND));
            return new BannerInfo(kind, json.getString(CONTENT));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}

