/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.api.security.Permission;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PermissionJsonWriter
implements MessageBodyWriter<Permission> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Permission.class.isAssignableFrom(type);
    }

    public long getSize(Permission permission, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Permission permission, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(permission).getBytes());
    }

    @VisibleForTesting
    String toJson(Permission permission) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        PermissionJsonWriter.writeJson(permission, writer);
        return stringWriter.toString();
    }

    static void writeJson(Permission permission, JsonWriter writer) {
        writer.object();
        writer.key("level").value((Object)permission.getLevel());
        writer.key("permissionName").value((Object)permission.getPermissionName());
        if (!Strings.isNullOrEmpty((String)permission.getRoot())) {
            writer.key("root").value((Object)permission.getRoot());
        }
        writer.endObject();
    }
}

