package com.xebialabs.deployit.core.service.impl

import java.util.{List => JList}

import ai.digital.deploy.sql.model.settings.FeatureSettings
import com.xebialabs.deployit.core.service.FeatureSettingsService
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getSubtypes
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.core.Directory
import com.xebialabs.deployit.repository.{RepositoryService, SearchParameters}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import scala.jdk.CollectionConverters._

@Service
class FeatureSettingsServiceImpl(@Autowired repositoryService: RepositoryService)
  extends FeatureSettingsService {

  val parentId = "/Configuration/features"

  override def getFeatureSettings(): JList[FeatureSettings] = {
    val features = repositoryService.listEntities[FeatureSettings](new SearchParameters().setParent(parentId), Integer.MAX_VALUE, false).asScala

    getSubtypes(Type.valueOf(classOf[FeatureSettings])).asScala.map { featureType =>
      features.find(_.getType == featureType).getOrElse {
        val feature = featureType.getDescriptor.newInstance[FeatureSettings]("")
        feature.generateId()
        feature
      }
    }.toList.sortBy(_.getType.getDescriptor.getLabel).asJava
  }

  override def updateFeatureSettings(features: JList[FeatureSettings]): Unit = {

    if (!repositoryService.exists(parentId)) {
      val dir = new Directory
      dir.setId(parentId)
      repositoryService.create(dir)
    }
    repositoryService.createOrUpdateCis(features, null)
  }
}
