package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.xltype.serialization.json.DeploymentJsonConverter;
import com.xebialabs.xltype.serialization.json.SelectedDeploymentJsonConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class SelectedDeploymentJsonReaderWriter implements MessageBodyWriter<SelectedDeployment>, MessageBodyReader<SelectedDeployment> {
    private final DeploymentJsonConverter deploymentJsonConverter = new DeploymentJsonConverter(new PasswordEncryptingCiConverter());
    private final SelectedDeploymentJsonConverter selectedDeploymentJsonConverter = new SelectedDeploymentJsonConverter(deploymentJsonConverter);
    private final ReaderPostProcessor postProcessor;

    @Autowired
    public SelectedDeploymentJsonReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return isReadable(type, genericType, annotations, mediaType);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return SelectedDeployment.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final SelectedDeployment deployment, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final SelectedDeployment deployment, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(deployment).getBytes());
    }

    @Override
    public SelectedDeployment readFrom(Class<SelectedDeployment> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return toSelectedDeployment(toString(entityStream));
    }

    @VisibleForTesting
    String toJson(SelectedDeployment deployment) {
        return selectedDeploymentJsonConverter.toJson(deployment);
    }

    @VisibleForTesting
    SelectedDeployment toSelectedDeployment(String deployment) {
        return postProcessor.apply(context -> {
            context.register(deploymentJsonConverter.getCiConverter());
            return selectedDeploymentJsonConverter.toSelectedDeployment(deployment);
        });
    }

    public String toString(InputStream in) throws IOException {
        return CharStreams.toString(new InputStreamReader(in, Charsets.UTF_8));
    }
}
