package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.xltype.serialization.json.Converters;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class BlockStateJsonWriter implements MessageBodyWriter<BlockState> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return BlockState.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(BlockState blockState, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    @Override
    public void writeTo(BlockState blockState, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(blockState).getBytes());
    }

    @VisibleForTesting
    String toJson(BlockState blockState) {
        JsonWriter writer = new JsonWriter(new StringWriter());
        Converters.writeBlockTree(blockState, writer, true);
        return writer.toString();
    }
}
