package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemIdAndReferenceId;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class ConfigurationItemIdJsonWriter implements MessageBodyWriter<ConfigurationItemId> {

    @Override
    public boolean isWriteable(Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return ConfigurationItemId.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(final ConfigurationItemId configurationItemId, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final ConfigurationItemId configurationItemId, final Class<?> type, final java.lang.reflect.Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(configurationItemId).getBytes());
    }

    @VisibleForTesting
    String toJson(ConfigurationItemId configurationItemId) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writeJson(configurationItemId, writer);
        return stringWriter.toString();
    }

    public void writeJson(final ConfigurationItemId configurationItemId, final JsonWriter writer) {
        writer.object();
        writer.key("ref").value(configurationItemId.getId());
        writer.key("type").value(configurationItemId.getType());
        if (configurationItemId instanceof ConfigurationItemIdAndReferenceId) {
            writer.key("$referenceId").value(((ConfigurationItemIdAndReferenceId) configurationItemId).getReferenceId());
        }
        writer.endObject();
    }
}
