package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.springframework.stereotype.Component;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class MapStringSetStringJsonWriter implements MessageBodyWriter<Map<String, Set<String>>> {

    @Override
    public boolean isWriteable(Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        if (mediaType.toString().contains(MediaType.APPLICATION_JSON) && Map.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType) genericType).getActualTypeArguments();
            Class<?> typeKey = (Class<?>) types[0];
            if (types[1] instanceof ParameterizedType) {
                ParameterizedType parametrizedTypeValue = (ParameterizedType) types[1];
                Class<?> typeValue = (Class<?>) parametrizedTypeValue.getRawType();
                Type typeValueItem = parametrizedTypeValue.getActualTypeArguments()[0];
                return String.class.isAssignableFrom(typeKey) && Set.class.isAssignableFrom(typeValue) && typeValueItem instanceof Class && String.class.isAssignableFrom((Class<?>) typeValueItem);
            }
        }
        return false;
    }

    @Override
    public long getSize(final Map<String, Set<String>> map, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(final Map<String, Set<String>> map, final Class<?> type, final Type genericType, final Annotation[] annotations, final MediaType mediaType, final MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(toJson(map).getBytes());
    }

    @VisibleForTesting
    String toJson(Map<String, Set<String>> map) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter);
        writer.object();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            writer.key(entry.getKey());
            writer.array();
            for (String descriptor : entry.getValue()) {
                writer.value(descriptor);
            }
            writer.endArray();
        }
        writer.endObject();
        return stringWriter.toString();
    }
}
