/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

abstract class DashboardWidgetBase
extends TaskArchiveReport
implements Widget {
    protected static final int TOP_N = 10;
    protected static final String NUMBER_SUCCESSFUL_DEPLOYMENTS = "noOfSuccessfulDeployments";
    protected static final String NUMBER_ABORTED_DEPLOYMENTS = "noOfAbortedDeployments";
    protected static final String NUMBER_FAILED_DEPLOYMENTS = "noOfFailedDeployments";
    protected static final String NUMBER_ROLLBACK_DEPLOYMENTS = "noOfRollbacks";
    protected static final String MONTH = "month";
    public static final String ZERO = String.format("%.2f", 0.0);

    protected DashboardWidgetBase(TaskArchive taskArchive) {
        super(taskArchive);
    }

    protected static final double getPercentage(double numOfTasksInAState, double totalTasks) {
        Preconditions.checkArgument((numOfTasksInAState <= totalTasks ? 1 : 0) != 0, (Object)("Number of deplyments in a state passed to the percentage function cannot be greater than total number of deployments! numOfDeployment :" + numOfTasksInAState + "totalDeployment:" + totalTasks));
        return totalTasks == 0.0 ? 0.0 : numOfTasksInAState / totalTasks * 100.0;
    }

    protected static final String getFormattedPercentage(double numOfTasksInAState, double totalTasks) {
        DecimalFormat df = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return df.format(DashboardWidgetBase.getPercentage(numOfTasksInAState, totalTasks));
    }

    protected static final String getFormattedMonth(int monthOfYear) {
        return Month.of(monthOfYear).getDisplayName(TextStyle.SHORT, Locale.US);
    }

    static final String formatToMinsAndSecs(long millis) {
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis));
        Object seconds = String.valueOf(secs);
        if (secs < 10L) {
            seconds = "0" + (String)seconds;
        }
        return String.format("%d:%s", TimeUnit.MILLISECONDS.toMinutes(millis), seconds);
    }

    protected static final String formatToSecs(long millis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);
        return String.format("%d", seconds);
    }

    protected static final String formatToMins(long millis) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(minutes);
        if (seconds >= 30L) {
            ++minutes;
        }
        return String.format("%d", minutes);
    }

    protected static final String formatToHours(long millis) {
        long hours = TimeUnit.MILLISECONDS.toHours(millis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) - TimeUnit.HOURS.toMinutes(hours);
        if (minutes >= 30L) {
            ++hours;
        }
        return String.format("%d", hours);
    }
}

