package com.xebialabs.deployit.core.auth

import java.util

import ai.digital.deploy.sql.model.{LoginMetadata, LoginProvider, ViewAs}
import com.google.common.collect.Lists.newArrayList
import com.xebialabs.deployit.security.{Permissions, RoleService, SecurityServiceLocator}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.security.authentication.AnonymousAuthenticationToken
import org.springframework.stereotype.Component

@Component
class LoginMetadataService @Autowired()(val loginProviders: util.List[LoginProvider] = newArrayList(),
                                        val roleService: RoleService) {

  def getLoginMetadata: LoginMetadata = {
    val viewAsData = SecurityServiceLocator.getViewAsData
    val userName =
      if (Permissions.getAuthentication.isInstanceOf[AnonymousAuthenticationToken])
        null
      else
        Permissions.getAuthenticatedUserName
    LoginMetadata(userName, loginProviders, ViewAs.fromViewAsData(viewAsData), roleService.isReadOnlyAdmin())
  }
}
