package com.xebialabs.deployit.core.rest.json

import java.io.{OutputStream, OutputStreamWriter}

import com.xebialabs.deployit.engine.api.execution.BlockState
import com.xebialabs.xltype.serialization.json.{Converters, JsonWriter}

object TaskWriterUtil {
  def writeTaskWithBlock(stream: OutputStream, fields: List[(String, Any)], blockState: Option[BlockState]): Unit = {
    val streamWriter = new OutputStreamWriter(stream)
    val writer = new JsonWriter(streamWriter)
    writer.`object`()
    fields.foreach { case (key, value) => writer.key(key).value(value) }
    blockState.foreach { block =>
      writer.key("block")
      Converters.writeBlockTree(block, writer, true)
    }
    writer.endObject()
    streamWriter.flush()
  }
}
