/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.mappers;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.core.rest.mappers.ClosingExceptionMapper;
import com.xebialabs.deployit.core.rest.mappers.DeployitExceptionMapper;
import com.xebialabs.deployit.core.rest.mappers.Exceptions;
import com.xebialabs.deployit.core.rest.mappers.Sanitizer;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Provider
@Component
public class UnhandledExceptionMapper
extends ClosingExceptionMapper<RuntimeException>
implements ExceptionMapper<RuntimeException> {
    private static final Logger logger = LoggerFactory.getLogger(UnhandledExceptionMapper.class);
    private final DeployitExceptionMapper deployitHandler;

    @Autowired
    public UnhandledExceptionMapper(ClientProperties config) {
        super(config.hideInternals());
        this.deployitHandler = new DeployitExceptionMapper(XStreamReaderWriter.getConfiguredXStream(), config);
    }

    @Override
    protected Response handleException(RuntimeException exception) {
        if (exception instanceof DeployitException) {
            return this.deployitHandler.toResponse((DeployitException)exception);
        }
        logger.error("Unhandled Exception: {}", (Throwable)exception);
        String content = Exceptions.getAllMessages(exception);
        int status = 500;
        Response handled = this.checkWhetherWeHideInternals(status, exception, content);
        if (handled != null) {
            return handled;
        }
        Response.ResponseBuilder builder = Response.serverError().type("text/plain");
        builder.header("X-Unhandled-Exception", (Object)"true");
        builder.header("X-Exception-Type", (Object)exception.getClass().getName());
        builder.header("X-Path", PathInterceptor.PATH.get());
        builder.entity((Object)Sanitizer.sanitize(content));
        return builder.build();
    }
}

