package com.xebialabs.deployit.core.rest.mappers;

import java.util.ArrayList;
import java.util.List;

public class Exceptions {

    public static String getAllMessages(Exception e) {
        List<String> msgs = new ArrayList<>();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            String message = cause.getLocalizedMessage();
            if (message == null) {
                if (cause.getCause() == null) {
                    msgs.add(cause.toString());
                }
            } else {
                if (cause.getCause() == null || !cause.getCause().toString().equals(message)) {
                    msgs.add(message);
                }
            }
        }
        return String.join("\n", msgs);
    }
}
