/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.core.common.security.permission.DeployitPermissions;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
class PermissionChecker {
    PermissionChecker() {
    }

    public void checkPermission(Deployment deployment, List<List<Deployment>> dependencies) {
        this.checkPermission(deployment);
        this.checkApplicationPermissions(dependencies, HasPermission.hasPermission());
        dependencies.forEach(depl -> depl.forEach(d -> {
            try {
                this.checkPermission((Deployment)d);
            }
            catch (InvalidDeploymentException e) {
                StringBuilder errorMsgBuilder = new StringBuilder(e.getMessage());
                errorMsgBuilder.append(String.format("The error occurred while deploying dependencies for application \"%s\"", deployment.getDeployedApplication().getName()));
                throw new InvalidDeploymentException(errorMsgBuilder.toString());
            }
        }));
    }

    private void checkApplicationPermissions(List<List<Deployment>> allDeployments, HasPermission f) {
        allDeployments.stream().forEach(deployments -> deployments.stream().forEach(deployment -> {
            DeployedApplication deployedApplication = this.checkAndCast(deployment.getDeployedApplication(), DeployedApplication.class);
            String applicationId = deployedApplication.getVersion().getApplication().getId();
            if (!f.check(PlatformPermissions.READ, applicationId)) {
                throw new InvalidDeploymentException(String.format("Unable to satisfy application dependencies. Application \"%s\" not found.", deployedApplication.getName()));
            }
        }));
    }

    void checkPermission(Deployment deployment) {
        Permission deploymentPermission;
        switch (deployment.getDeploymentType()) {
            case INITIAL: {
                deploymentPermission = DeployitPermissions.DEPLOY_INITIAL();
                break;
            }
            case UPDATE: {
                deploymentPermission = DeployitPermissions.DEPLOY_UPGRADE();
                break;
            }
            case UNDEPLOYMENT: {
                deploymentPermission = DeployitPermissions.UNDEPLOY();
                break;
            }
            default: {
                throw new InvalidDeploymentException(String.format("Unable to determine deployment type \"%s\"", deployment.getDeploymentType()));
            }
        }
        DeployedApplication deployedApplication = (DeployedApplication)deployment.getDeployedApplication();
        try {
            this.checkPermission(deploymentPermission, deployedApplication.getEnvironment());
        }
        catch (InvalidDeploymentException e) {
            StringBuilder errorMsgBuilder = new StringBuilder("You do not have the required permissions.");
            errorMsgBuilder.append(String.format(" Application \"%s\" requires \"%s\" permission on environment \"%s\".", deployedApplication.getName(), deploymentPermission.getPermissionName(), deployedApplication.getEnvironment().getName()));
            throw new InvalidDeploymentException(errorMsgBuilder.toString());
        }
    }

    void checkPermission(Permission permission, Environment environment) {
        String environmentID = environment.getId();
        if (!permission.getPermissionHandler().hasPermission(environmentID)) {
            String errorMsgBuilder = "You do not have the required permissions." + String.format("\"%s\" permission is required on environment \"%s\".", permission.getPermissionName(), environment.getName());
            throw new InvalidDeploymentException(errorMsgBuilder);
        }
    }

    private <T extends ConfigurationItem> T checkAndCast(ConfigurationItem ci, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci));
    }

    @FunctionalInterface
    static interface HasPermission {
        public boolean check(Permission var1, String var2);

        public static HasPermission hasPermission() {
            return (p, ciId) -> p.getPermissionHandler().hasPermission(ciId);
        }
    }
}

