package com.xebialabs.deployit.core.rest.api

import ai.digital.deploy.sql.model.BannerInfo
import ai.digital.deploy.sql.model.BannerInfo.BannerKind
import com.xebialabs.deployit.core.api.BannerService
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource
import com.xebialabs.deployit.repository.BannerRepository
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class BannerServiceImpl @Autowired()(bannerRepository: BannerRepository) extends AbstractSecuredResource with BannerService {

  override def getBannerInfo(kind: BannerKind): BannerInfo =
    bannerRepository.get(kind).getOrElse(new BannerInfo(kind, null))

  override def updateBannerInfo(bannerInfo: BannerInfo): Unit = {
    checkPermission(ADMIN)
    bannerRepository.update(bannerInfo)
  }
}
