package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.PackageExportProxy;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.version.exporter.ExporterService;
import com.xebialabs.overthere.local.LocalFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.xebialabs.deployit.core.rest.resteasy.Workdir.Clean.ALWAYS;
import static com.xebialabs.deployit.repository.WorkDirFactory.EXPORT_WORKDIR_PREFIX;

/**
 * I am A REST resource that exposes functionality of exporting a deployment
 * package version.
 */
@Service
public class PackageExportResource extends AbstractSecuredResource implements PackageExportProxy {

    @Autowired
    private ExporterService exporterService;

    @Autowired
    private DownloadResource downloadResource;

    @Override
    @Workdir(prefix = EXPORT_WORKDIR_PREFIX, clean = ALWAYS)
    public String exportDar(final String id) {
        WorkDir workDir = WorkdirHolder.get();
        LocalFile file = exporterService.exportDar(id, workDir);
        return downloadResource.register(file.getFile(), "application/zip");
    }
}
