package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.core.rest.json.TaskWriterUtil.writeTaskWithBlock
import com.xebialabs.deployit.engine.api.dto.ControlTaskReportLine
import com.xebialabs.xltype.serialization.util.DateUtil
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class ControlTaskReportLineWriter extends MessageBodyWriter[ControlTaskReportLine] {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[ControlTaskReportLine].isAssignableFrom(`type`)

  override def writeTo(line: ControlTaskReportLine,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    writeTaskWithBlock(
      entityStream,
      List(
        "owner" -> line.getOwner,
        "controlTaskTargetCI" -> line.getControlTaskTargetCI,
        "description" -> line.getDescription,
        "started" -> DateUtil.toString(line.getStarted),
        "finished" -> DateUtil.toString(line.getFinished),
        "taskName" -> line.getTaskName,
        "state" -> line.getState,
        "taskId" -> line.getTaskId,
        "worker_name" -> line.getWorkerName
      ),
      Option(line.getBlock)
    )
  }
}
