package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.archive.TaskArchive;

import java.util.EnumSet;
import java.util.Map;

import static ai.digital.deploy.tasker.common.TaskType.*;

public abstract class TaskArchiveReport {

    protected final TaskArchive taskArchive;
    private final ArchivedTaskSearchParameters searchParameters;

    public TaskArchiveReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
        this.searchParameters = new ArchivedTaskSearchParameters();
        this.searchParameters.thatAreOfType(EnumSet.of(INITIAL, ROLLBACK, UNDEPLOY, UPGRADE));
    }

    public ArchivedTaskSearchParameters getSearchParameters() {
        return searchParameters;
    }

    public ArchivedTaskSearchParameters cloneSearchParameters() {
        return new ArchivedTaskSearchParameters(searchParameters);
    }

    protected Object getValue(Map<String, Object> task, String propName) {
        return task.get(propName);
    }

}
