package com.xebialabs.deployit.core.rest.sql

import com.xebialabs.deployit.repository.sql.reader.CiReaderContext
import jakarta.ws.rs.container._
import jakarta.ws.rs.core.{Feature, FeatureContext}
import jakarta.ws.rs.ext.Provider
import org.springframework.stereotype.Component

@Provider
class SqlSessionDuringRequestInterceptor extends ContainerRequestFilter {

  override def filter(requestContext: ContainerRequestContext): Unit =
    CiReaderContext.init()
}

@Provider
class SqlSessionDuringResponseInterceptor extends ContainerResponseFilter {

  override def filter(requestContext: ContainerRequestContext, responseContext: ContainerResponseContext): Unit =
    CiReaderContext.clear()
}

@Component
@Provider
class SqlSessionFeature extends Feature {

  override def configure(context: FeatureContext): Boolean = {
    context.register(new SqlSessionDuringRequestInterceptor, classOf[ContainerRequestFilter])
    context.register(new SqlSessionDuringResponseInterceptor, classOf[ContainerResponseFilter])
    true
  }

}
