package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.InternalComparisonProxy;
import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.comparison.Comparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.toList;

@Service
public class ComparisonResource extends AbstractSecuredResource implements InternalComparisonProxy {

    @Autowired
    private RepositoryService repositoryService;

    @Autowired
    private Comparator comparator;

    @Override
    public Comparison compare(String reference, List<String> ids) {
        ConfigurationItem referenceEntity = repositoryService.read(reference);

        final Map<String, List<String>> multimap = comparator.compare(referenceEntity,
                ids.stream().map(input -> (ConfigurationItem) repositoryService.read(input)).collect(toList()));

        return Comparison.from(multimap);
    }
}
