package com.xebialabs.deployit.core.converters

import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder
import com.xebialabs.xltype.serialization.json.JsonWriter

import scala.jdk.CollectionConverters._

class ResolvedPlaceholdersConverter {
  def resolvedPlaceholderConverter = new ResolvedPlaceholderConverter()

  def toJson(resoledPlaceholders: java.util.Collection[ResolvedPlaceholder]): String = {
    val writer = new JsonWriter
    writer.array()
    resoledPlaceholders.asScala.foreach(placeholder => resolvedPlaceholderConverter.toJson(placeholder, writer))
    writer.endArray()
    writer.toString
  }
}
