package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.core.converters.ResolvedPlaceholdersConverter;
import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import org.springframework.stereotype.Component;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;

@Component
@Provider
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public class ResolvedPlaceholdersWriter implements MessageBodyWriter<Collection<ResolvedPlaceholder>> {

    private final ResolvedPlaceholdersConverter converter = new ResolvedPlaceholdersConverter();
    private final JsonWriterHelper helper = new JsonWriterHelper();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!mediaType.toString().contains(MediaType.APPLICATION_JSON)) {
            return false;
        }

        return ResolvedPlaceholder.class.isAssignableFrom(helper.getType(type, genericType));
    }

    @Override
    public long getSize(Collection<ResolvedPlaceholder> resolvedPlaceholders, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Collection<ResolvedPlaceholder> resolvedPlaceholders, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(converter.toJson(resolvedPlaceholders).getBytes());
    }
}
