/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.xltype.serialization.json.Converters;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class BlockStateJsonWriter
implements MessageBodyWriter<BlockState> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return BlockState.class.isAssignableFrom(type);
    }

    public long getSize(BlockState blockState, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(BlockState blockState, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(blockState).getBytes());
    }

    @VisibleForTesting
    String toJson(BlockState blockState) {
        JsonWriter writer = new JsonWriter((Writer)new StringWriter());
        Converters.writeBlockTree((BlockState)blockState, (JsonWriter)writer, (boolean)true);
        return writer.toString();
    }
}

