/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.configuration.central.deploy.converter.HoconDurationConverter$;
import ai.digital.deploy.sql.model.WorkerInfo;
import com.xebialabs.deployit.core.api.WorkersService;
import com.xebialabs.deployit.core.rest.api.WorkerState$;
import com.xebialabs.deployit.core.rest.api.WorkersSorting$;
import com.xebialabs.deployit.core.rest.api.support.PaginationSupport$;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Worker;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.spring.BeanWrapper;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import scala.Enumeration;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001\u0002\u000b\u0016\u0001\tB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t9\u0002\u0011\t\u0011)A\u0005;\"A1\r\u0001B\u0001B\u0003%q\r\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003q\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013A\u0011\"!\t\u0001\u0005\u0004%Y!a\t\t\u0011\u0005E\u0002\u0001)A\u0005\u0003KA\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005-\u0003\u0001)A\u0005\u0003oA\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\t\u0013\u0005U\u0004\u00011A\u0005\u0002\u0005]\u0004\u0002CAC\u0001\u0001\u0006K!!\u001b\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011\u001d\ty\r\u0001C!\u0003#Dq!!6\u0001\t\u0003\n9\u000eC\u0004\u0002Z\u0002!\t%a7\u0003\u001f]{'o[3sgJ+7o\\;sG\u0016T!AF\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u00193\u0005!!/Z:u\u0015\tQ2$\u0001\u0003d_J,'B\u0001\u000f\u001e\u0003!!W\r\u001d7ps&$(B\u0001\u0010 \u0003%AXMY5bY\u0006\u00147OC\u0001!\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011%\u000b\u0018\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019:\u0012aB:fGV\u0014X\rZ\u0005\u0003Q\u0015\u0012q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005)bS\"A\u0016\u000b\u0005YI\u0012BA\u0017,\u000599vN]6feN\u001cVM\u001d<jG\u0016\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u000bMdg\r\u000e6\u000b\u0003M\n\u0001b\u001a:jujdW\rZ\u0005\u0003kA\u0012q\u0001T8hO&tw-A\u0007x_J\\WM]'b]\u0006<WM\u001d\t\u0004qmjT\"A\u001d\u000b\u0005iZ\u0012AB:qe&tw-\u0003\u0002=s\tY!)Z1o/J\f\u0007\u000f]3s!\tqt)D\u0001@\u0015\t\u0001\u0015)A\u0003bGR|'O\u0003\u0002C\u0007\u0006)\u0001/Z6l_*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tAuH\u0001\u0005BGR|'OU3gQ\t\t!\n\u0005\u0002L)6\tAJ\u0003\u0002N\u001d\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005=\u0003\u0016a\u00024bGR|'/\u001f\u0006\u0003#J\u000bQAY3b]NT!aU#\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!!\u0016'\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\u0006B\u0001X5n\u0003\"a\u0013-\n\u0005ec%!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00051\u0014\u0001E<pe.,'OU3q_NLGo\u001c:z!\tqF-D\u0001`\u0015\t\u0001\u0017-\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002\u0017E*\u00111mG\u0001\u0007K:<\u0017N\\3\n\u0005\u0015|&!\b+bg.,\u00050Z2vi&|gnV8sW\u0016\u0014(+\u001a9pg&$xN]=)\u0005\tQ\u0005c\u0001\u001d<QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111NY\u0001\u0007i\u0006\u001c8.\u001a:\n\u00055T'a\u0005+bg.,\u00050Z2vi&|g.\u00128hS:,\u0007FA\u0002K\u0003)\t7o\u001b+j[\u0016|W\u000f\u001e\t\u0003cjt!A\u001d=\u0011\u0005M4X\"\u0001;\u000b\u0005U\f\u0013A\u0002\u001fs_>$hHC\u0001x\u0003\u0015\u00198-\u00197b\u0013\tIh/\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u0014aa\u0015;sS:<'BA=wQ\u0015!aPWA\u0002!\tYu0C\u0002\u0002\u00021\u0013QAV1mk\u0016\f#!!\u0002\u0002E\u0011Z\b\u0010\u001c\u0018uCN\\WM\u001d\u0018bg.$\u0016.\\3pkRT\u0014\u0007\r\u0011tK\u000e|g\u000eZ:~\u0003\u0019a\u0014N\\5u}QQ\u00111BA\b\u0003+\tI\"!\b\u0011\u0007\u00055\u0001!D\u0001\u0016\u0011\u00151T\u00011\u00018Q\r\tyA\u0013\u0015\u0006\u0003\u001f9&l\u0017\u0005\u00069\u0016\u0001\r!\u0018\u0015\u0004\u0003+Q\u0005\"B2\u0006\u0001\u00049\u0007fAA\r\u0015\")q.\u0002a\u0001a\"2\u0011Q\u0004@[\u0003\u0007\tq\u0001^5nK>,H/\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\u0005\u000bA!\u001e;jY&!\u0011qFA\u0015\u0005\u001d!\u0016.\\3pkR\f\u0001\u0002^5nK>,H\u000fI\u0001\rQR$\bOU3ta>t7/Z\u000b\u0003\u0003o\u0001B!!\u000f\u0002H5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0002ta&TA!!\u0011\u0002D\u0005A!/Z:uK\u0006\u001c\u0018PC\u0002\u0002F\u0015\u000bQA\u001b2pgNLA!!\u0013\u0002<\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006i\u0001\u000e\u001e;q%\u0016\u001c\bo\u001c8tK\u0002B3!CA(!\u0011\t\t&!\u0019\u000e\u0005\u0005M#b\u0001\u000e\u0002V)!\u0011qKA-\u0003\t\u00118O\u0003\u0003\u0002\\\u0005u\u0013AA<t\u0015\t\ty&A\u0004kC.\f'\u000f^1\n\t\u0005\r\u00141\u000b\u0002\b\u0007>tG/\u001a=u\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=4$\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\u0019(!\u001c\u0003\u0017I{G.Z*feZL7-Z\u0001\u0010e>dWmU3sm&\u001cWm\u0018\u0013fcR!\u0011\u0011PAA!\u0011\tY(! \u000e\u0003YL1!a w\u0005\u0011)f.\u001b;\t\u0013\u0005\r5\"!AA\u0002\u0005%\u0014a\u0001=%c\u0005a!o\u001c7f'\u0016\u0014h/[2fA!\u0012ABS\u0001\u0010g\",H\u000fZ8x]^{'o[3sgR!\u0011\u0011PAG\u0011\u001d\ty)\u0004a\u0001\u0003#\u000bqa^8sW\u0016\u00148\u000fE\u0003\u0002\u0014\u0006m\u0005/\u0004\u0002\u0002\u0016*!\u00111FAL\u0015\t\tI*\u0001\u0003kCZ\f\u0017\u0002BAO\u0003+\u0013A\u0001T5ti\u0006q1\u000f[;uI><hnV8sW\u0016\u0014H\u0003BA=\u0003GCq!!*\u000f\u0001\u0004\t9+\u0001\u0005x_J\\WM]%e!\u0011\tI+a,\u000e\u0005\u0005-&\u0002BAW\u0003/\u000bA\u0001\\1oO&!\u0011\u0011WAV\u0005\u001dIe\u000e^3hKJ\fQ\"[:M_\u000e\fGnV8sW\u0016\u0014H\u0003BA\\\u0003{\u0003B!a\u001f\u0002:&\u0019\u00111\u0018<\u0003\u000f\t{w\u000e\\3b]\"1\u0011qX\bA\u0002A\fq!\u00193ee\u0016\u001c8/A\u000buQJ|w\u000fT8dC2<vN]6fe\u0016\u0013(o\u001c:\u0015\t\u0005\u0015\u00171\u001a\t\u0005\u0003w\n9-C\u0002\u0002JZ\u0014qAT8uQ&tw\r\u0003\u0004\u0002NB\u0001\r\u0001]\u0001\u0002g\u0006a!/Z7pm\u0016<vN]6feR!\u0011\u0011PAj\u0011\u001d\t)+\u0005a\u0001\u0003O\u000bAC]3sK\u001eL7\u000f^3s\u000f\"|7\u000f\u001e+bg.\u001cHCAAI\u0003-a\u0017n\u001d;X_J\\WM]:\u0015\r\u0005u\u00171 B\u0006!\u0019\t\u0019*a'\u0002`B!\u0011\u0011]A|\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!B7pI\u0016d'\u0002BAu\u0003W\f1a]9m\u0015\u0011\ti/a<\u0002\r\u0011,\u0007\u000f\\8z\u0015\u0011\t\t0a=\u0002\u000f\u0011Lw-\u001b;bY*\u0011\u0011Q_\u0001\u0003C&LA!!?\u0002d\nQqk\u001c:lKJLeNZ8\t\u000f\u0005u8\u00031\u0001\u0002\u0000\u00061\u0001/Y4j]\u001e\u0004BA!\u0001\u0003\b5\u0011!1\u0001\u0006\u0004\u0005\u000b\t\u0017a\u00013u_&!!\u0011\u0002B\u0002\u0005\u0019\u0001\u0016mZ5oO\"9!QB\nA\u0002\t=\u0011!B8sI\u0016\u0014\b\u0003\u0002B\u0001\u0005#IAAa\u0005\u0003\u0004\tAqJ\u001d3fe&tw\rK\u0002\u0001\u0005/\u0001BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;\u0011\u0016AC:uKJ,w\u000e^=qK&!!\u0011\u0005B\u000e\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class WorkersResource
extends AbstractSecuredResource
implements WorkersService,
Logging {
    @Autowired
    @Qualifier(value="workerManager")
    private final BeanWrapper<ActorRef> workerManager;
    @Autowired
    private final TaskExecutionWorkerRepository workerRepository;
    @Autowired
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final Timeout timeout;
    @Context
    private final HttpResponse httpResponse;
    @Autowired
    private RoleService roleService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkersResource workersResource = this;
        synchronized (workersResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Timeout timeout() {
        return this.timeout;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public void shutdownWorkers(java.util.List<String> workers) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (workers.isEmpty()) {
            this.logger().info((Function0 & Serializable)() -> "Shutting down all workers.");
        } else {
            this.logger().info((Function0 & Serializable)() -> "Shutting down workers " + workers + ".");
        }
        CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().find((Function1 & Serializable)address -> BoxesRunTime.boxToBoolean((boolean)this.isLocalWorker(address))).foreach((Function1 & Serializable)s -> this.throwLocalWorkerError((String)s));
        this.workerRepository.listWorkers().map((Function1 & Serializable)x$1 -> (Worker)x$1._1()).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorkers$6(this, workers, worker);
            return BoxedUnit.UNIT;
        });
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$12 = new WorkerManager.messages$.ShutdownWorker(CollectionConverters$.MODULE$.ListHasAsScala(workers).asScala().toList(), true);
        Timeout x$2 = this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$12);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$12, x$2, x$3), (Duration)this.timeout().duration());
        if (!workers.isEmpty()) {
            List shutdownWorkers = response.workers();
            this.logger().info((Function0 & Serializable)() -> "Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.");
            ArrayList<String> notFound = new ArrayList<String>(workers);
            notFound.removeAll(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)shutdownWorkers).asJava());
            if (!notFound.isEmpty()) {
                throw new NotFoundException("Workers " + CollectionConverters$.MODULE$.ListHasAsScala(notFound).asScala().mkString("[", ", ", "]") + " not found. (Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.)");
            }
            return;
        }
    }

    public void shutdownWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Worker for id " + workerId + " not found.");
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$shutdownWorker$2(this, worker);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isLocalWorker(String address) {
        return AddressFromURIString$.MODULE$.apply(address).hasLocalScope();
    }

    private Nothing$ throwLocalWorkerError(String s) {
        throw new IllegalArgumentException("Local worker (" + s + ") cannot be shutdown.");
    }

    public void removeWorker(Integer workerId) {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.workerRepository.getWorker(workerId).orElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Worker for id " + workerId + " not found.");
        }).foreach((Function1 & Serializable)worker -> {
            WorkersResource.$anonfun$removeWorker$2(this, workerId, worker);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.List<String> reregisterGhostTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        return ((TaskExecutionEngine)this.engine.get()).reregisterGhostTasks();
    }

    public java.util.List<WorkerInfo> listWorkers(Paging paging, com.xebialabs.deployit.engine.api.dto.Ordering order) {
        if (!this.hasPermission(PlatformPermissions.ADMIN) && !this.roleService().isReadOnlyAdmin()) {
            throw PermissionDeniedException.forPermission((Permission)PlatformPermissions.ADMIN, (String)"");
        }
        Timeout timeout = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)this.workerManager.get());
        WorkerManager.messages$.FetchWorkers x$1 = new WorkerManager.messages$.FetchWorkers();
        Timeout x$22 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$22, x$3), (Duration)timeout.duration());
        List workers = this.workerRepository.listWorkers().map(Function$.MODULE$.tupled((Function3 & Serializable)(w, deploymentTasks, controlTasks) -> new WorkerInfo(Predef$.MODULE$.Integer2int(w.id()), w.name(), w.address(), WorkersResource.calculateState$1(w, response.healthy(), response.incompatible(), response.draining()).toString(), Predef$.MODULE$.Integer2int(deploymentTasks), Predef$.MODULE$.Integer2int(controlTasks))));
        if ((paging == null || paging.resultsPerPage() == -1) && order == null) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers.sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getId()), (Ordering)Ordering.Int$.MODULE$)).asJava().stream().collect(Collectors.toList());
        }
        PaginationSupport$.MODULE$.addTotalCountHeader((long)workers.size(), this.httpResponse());
        int from = (paging.page() - 1) * paging.resultsPerPage();
        int to = from + paging.resultsPerPage() <= CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size() ? from + paging.resultsPerPage() : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)workers).asJava().size();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)WorkersSorting$.MODULE$.sort((List<WorkerInfo>)workers, order).slice(from, to)).asJava();
    }

    public static final /* synthetic */ void $anonfun$shutdownWorkers$6(WorkersResource $this, java.util.List workers$1, Worker worker) {
        if (workers$1.isEmpty() || workers$1.contains(worker.address())) {
            $this.workerRepository.removeTasks(worker.id());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$shutdownWorker$2(WorkersResource $this, Worker worker) {
        String address = worker.address();
        if ($this.isLocalWorker(address)) {
            throw $this.throwLocalWorkerError(address);
        }
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages$.ShutdownWorker x$1 = new WorkerManager.messages$.ShutdownWorker((List)new .colon.colon((Object)address, (List)Nil$.MODULE$), false);
        Timeout x$2 = $this.timeout();
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        WorkerManager.messages$.WorkerShutdownStarted response = (WorkerManager.messages$.WorkerShutdownStarted)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)x$1, x$2, x$3), (Duration)$this.timeout().duration());
        List shutdownWorkers = response.workers();
        $this.logger().info((Function0 & Serializable)() -> "Workers " + shutdownWorkers.mkString("[", ", ", "]") + " shutdown.");
        if (!response.workers().contains((Object)address)) {
            throw new NotFoundException("Worker " + address + " not found.");
        }
    }

    public static final /* synthetic */ void $anonfun$removeWorker$2(WorkersResource $this, Integer workerId$2, Worker worker) {
        ActorRef x$3;
        Timeout x$2;
        WorkerManager.messages$.FetchWorkers x$1;
        ActorRef qual$1 = package$.MODULE$.ask((ActorRef)$this.workerManager.get());
        WorkerManager.messages.WorkersFetched response = (WorkerManager.messages.WorkersFetched)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(qual$1, (Object)(x$1 = new WorkerManager.messages$.FetchWorkers()), x$2 = $this.timeout(), x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)$this.timeout().duration());
        List active = (List)response.draining().$plus$plus((IterableOnce)response.healthy());
        if (active.contains((Object)worker.address())) {
            throw new IllegalArgumentException("Worker for id " + workerId$2 + " is still active, cannot be removed.");
        }
        $this.workerRepository.removeTasks(workerId$2);
        $this.workerRepository.removeWorker(workerId$2);
    }

    private static final Enumeration.Value calculateState$1(Worker w, List healthy, List incompatible, List draining) {
        if (healthy.contains((Object)w.address())) {
            return WorkerState$.MODULE$.CONNECTED();
        }
        if (incompatible.contains((Object)w.address())) {
            return WorkerState$.MODULE$.INCOMPATIBLE();
        }
        if (draining.contains((Object)w.address())) {
            return WorkerState$.MODULE$.DRAINING();
        }
        return WorkerState$.MODULE$.DISCONNECTED();
    }

    public WorkersResource(@Autowired @Qualifier(value="workerManager") BeanWrapper<ActorRef> workerManager, @Autowired TaskExecutionWorkerRepository workerRepository, @Autowired BeanWrapper<TaskExecutionEngine> engine, @Value(value="${xl.tasker.askTimeout:10 seconds}") String askTimeout) {
        this.workerManager = workerManager;
        this.workerRepository = workerRepository;
        this.engine = engine;
        Logging.$init$((Logging)this);
        this.timeout = new Timeout(HoconDurationConverter$.MODULE$.convert(askTimeout));
        this.httpResponse = null;
        this.roleService = null;
    }
}

