/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.service.impl;

import ai.digital.deploy.settings.GeneralSettings;
import ai.digital.deploy.settings.GeneralSettings$;
import ai.digital.deploy.sql.model.ConfigurationDto;
import ai.digital.deploy.sql.model.ConfigurationDto$;
import com.xebialabs.deployit.core.service.GeneralSettingsService;
import com.xebialabs.deployit.core.util.GeneralSettingsUtils$;
import com.xebialabs.deployit.repository.ConfigurationRepository;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001\u0002\n\u0014\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0013A\u0005BB*\u0001A\u0003%\u0011\nC\u0004U\u0001\t\u0007I\u0011\u0002%\t\rU\u0003\u0001\u0015!\u0003J\u0011\u001d1\u0006A1A\u0005\n!Caa\u0016\u0001!\u0002\u0013I\u0005b\u0002-\u0001\u0005\u0004%I!\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002.\t\u000b\r\u0004A\u0011\t3\t\u000bE\u0004A\u0011\t:\t\u000bU\u0004A\u0011\u0002<\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u00111\u0003\u0001\u0005\n\u0005U!AG$f]\u0016\u0014\u0018\r\\*fiRLgnZ:TKJ4\u0018nY3J[Bd'B\u0001\u000b\u0016\u0003\u0011IW\u000e\u001d7\u000b\u0005Y9\u0012aB:feZL7-\u001a\u0006\u00031e\tAaY8sK*\u0011!dG\u0001\tI\u0016\u0004Hn\\=ji*\u0011A$H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AH\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)S5\tQ#\u0003\u0002++\t1r)\u001a8fe\u0006d7+\u001a;uS:<7oU3sm&\u001cW-A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011Q\u0006M\u0007\u0002])\u0011q&G\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0019/\u0005]\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u000b\u0002\u0002gA\u0011AgP\u0007\u0002k)\u0011agN\u0001\u000bC:tw\u000e^1uS>t'B\u0001\u001d:\u0003\u001d1\u0017m\u0019;pefT!AO\u001e\u0002\u000b\t,\u0017M\\:\u000b\u0005qj\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003y\n1a\u001c:h\u0013\t\u0001UGA\u0005BkR|w/\u001b:fI\u00061A(\u001b8jiz\"\"aQ#\u0011\u0005\u0011\u0003Q\"A\n\t\u000b-\u0012\u0001\u0019\u0001\u0017)\u0005\u0015\u001b\u0014\u0001\u0004%F\u0003\u0012+%kX\"P\u0019>\u0013V#A%\u0011\u0005){U\"A&\u000b\u00051k\u0015\u0001\u00027b]\u001eT\u0011AT\u0001\u0005U\u00064\u0018-\u0003\u0002Q\u0017\n11\u000b\u001e:j]\u001e\fQ\u0002S#B\t\u0016\u0013vlQ(M\u001fJ\u0003\u0013!D%O'R\u000bejQ#`\u001d\u0006kU)\u0001\bJ\u001dN#\u0016IT\"F?:\u000bU*\u0012\u0011\u0002)1{u)\u0013(`'\u000e\u0013V)\u0012(`\u001b\u0016\u001b6+Q$F\u0003UaujR%O?N\u001b%+R#O?6+5kU!H\u000b\u0002\n\u0011\u0002T(H\u001f~3\u0015\nT#\u0002\u00151{uiT0G\u00132+\u0005%A\u0006tm\u001e\u001c\u0016MZ3MSN$X#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AB:bM\u0016$\u0018P\u0003\u0002`{\u0005)!n]8va&\u0011\u0011\r\u0018\u0002\t'\u00064W\r\\5ti\u0006a1O^4TC\u001a,G*[:uA\u0005\u0011r-\u001a;HK:,'/\u00197TKR$\u0018N\\4t+\u0005)\u0007C\u00014p\u001b\u00059'B\u00015j\u0003!\u0019X\r\u001e;j]\u001e\u001c(B\u00016l\u0003\u0019!W\r\u001d7ps*\u0011A.\\\u0001\bI&<\u0017\u000e^1m\u0015\u0005q\u0017AA1j\u0013\t\u0001xMA\bHK:,'/\u00197TKR$\u0018N\\4t\u0003U)\b\u000fZ1uK\u001e+g.\u001a:bYN+G\u000f^5oON$\"!Z:\t\u000bQt\u0001\u0019A3\u0002\u001f\u001d,g.\u001a:bYN+G\u000f^5oON\f\u0001c]1oSRL'0\u001a'pO>4\u0015\u000e\\3\u0015\u000b]\f\u0019!a\u0002\u0011\u0005a|hBA=~!\tQ8%D\u0001|\u0015\tax$\u0001\u0004=e>|GOP\u0005\u0003}\u000e\na\u0001\u0015:fI\u00164\u0017b\u0001)\u0002\u0002)\u0011ap\t\u0005\u0007\u0003\u000by\u0001\u0019A<\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u0005\u0007\u0003\u0013y\u0001\u0019A<\u0002\u00111|wm\u001c$jY\u0016\f1b]1oSRL'0Z*wOR\u0019q/a\u0004\t\r\u0005E\u0001\u00031\u0001x\u0003)\u0019hoZ\"p]R,g\u000e^\u0001\rg\u0006t\u0017\u000e^5{K\"#X\u000e\u001c\u000b\u0004o\u0006]\u0001BBA\r#\u0001\u0007q/\u0001\u0003ii6d\u0007f\u0001\u0001\u0002\u001eA!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$m\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9#!\t\u0003\u000fM+'O^5dK\u0002")
public class GeneralSettingsServiceImpl
implements GeneralSettingsService {
    @Autowired
    private final ConfigurationRepository configurationRepository;
    private final String HEADER_COLOR;
    private final String INSTANCE_NAME;
    private final String LOGIN_SCREEN_MESSAGE;
    private final String LOGO_FILE;
    private final Safelist svgSafeList;

    private String HEADER_COLOR() {
        return this.HEADER_COLOR;
    }

    private String INSTANCE_NAME() {
        return this.INSTANCE_NAME;
    }

    private String LOGIN_SCREEN_MESSAGE() {
        return this.LOGIN_SCREEN_MESSAGE;
    }

    private String LOGO_FILE() {
        return this.LOGO_FILE;
    }

    private Safelist svgSafeList() {
        return this.svgSafeList;
    }

    @Override
    public GeneralSettings getGeneralSettings() {
        ObjectRef headerColor = ObjectRef.create((Object)"");
        ObjectRef instanceName = ObjectRef.create((Object)"");
        ObjectRef loginScreenMessage = ObjectRef.create((Object)"");
        ObjectRef logoFile = ObjectRef.create((Object)"");
        List configurationList = this.configurationRepository.getConfigurationByKey();
        configurationList.foreach((Function1 & Serializable)x0$1 -> {
            GeneralSettingsServiceImpl.$anonfun$getGeneralSettings$1(this, headerColor, instanceName, loginScreenMessage, logoFile, x0$1);
            return BoxedUnit.UNIT;
        });
        return GeneralSettings$.MODULE$.apply((String)headerColor.elem, (String)instanceName.elem, (String)loginScreenMessage.elem, (String)logoFile.elem);
    }

    @Override
    public GeneralSettings updateGeneralSettings(GeneralSettings generalSettings) {
        GeneralSettings generalSettings2;
        if (generalSettings.logoFile() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(generalSettings.logoFile()))) {
            String sanitizedLogoFile;
            String logoMimeType = GeneralSettingsUtils$.MODULE$.getLogoMimeType(generalSettings.logoFile());
            String x$1 = sanitizedLogoFile = this.sanitizeLogoFile(logoMimeType, generalSettings.logoFile());
            String x$2 = generalSettings.copy$default$1();
            String x$3 = generalSettings.copy$default$2();
            String x$4 = generalSettings.copy$default$3();
            generalSettings2 = generalSettings.copy(x$2, x$3, x$4, x$1);
        } else {
            generalSettings2 = generalSettings;
        }
        GeneralSettings sanitizedGeneralSettings = generalSettings2;
        Set keysList = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.HEADER_COLOR(), this.INSTANCE_NAME(), this.LOGIN_SCREEN_MESSAGE(), this.LOGO_FILE()}));
        keysList.foreach((Function1 & Serializable)key -> {
            GeneralSettingsServiceImpl.$anonfun$updateGeneralSettings$1(this, generalSettings, sanitizedGeneralSettings, key);
            return BoxedUnit.UNIT;
        });
        return this.getGeneralSettings();
    }

    private String sanitizeLogoFile(String contentType, String logoFile) {
        Object object;
        String string = contentType;
        String string2 = "image/svg+xml";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            int base64Index = logoFile.indexOf("base64,") + "base64,".length();
            String base64Content = logoFile.substring(base64Index);
            byte[] decodedBytes = Base64.getDecoder().decode(base64Content);
            String imageContent = this.sanitizeSvg(new String(decodedBytes, StandardCharsets.UTF_8));
            byte[] sanitizedBytes = imageContent.getBytes(StandardCharsets.UTF_8);
            String sanitizedBase64Content = Base64.getEncoder().encodeToString(sanitizedBytes);
            object = logoFile.substring(0, base64Index) + sanitizedBase64Content;
        } else {
            object = logoFile;
        }
        String sanitizedContent = object;
        return sanitizedContent;
    }

    private String sanitizeSvg(String svgContent) {
        return Jsoup.clean((String)svgContent, (String)"", (Safelist)this.svgSafeList(), (Document.OutputSettings)new Document.OutputSettings().prettyPrint(false));
    }

    private String sanitizeHtml(String html) {
        return Jsoup.clean((String)html, (Safelist)Safelist.basic());
    }

    public static final /* synthetic */ void $anonfun$getGeneralSettings$1(GeneralSettingsServiceImpl $this, ObjectRef headerColor$1, ObjectRef instanceName$1, ObjectRef loginScreenMessage$1, ObjectRef logoFile$1, ConfigurationDto x0$1) {
        ConfigurationDto configurationDto = x0$1;
        if (configurationDto.key().endsWith($this.HEADER_COLOR())) {
            headerColor$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.INSTANCE_NAME())) {
            instanceName$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.LOGIN_SCREEN_MESSAGE())) {
            loginScreenMessage$1.elem = configurationDto.value();
            return;
        }
        if (configurationDto.key().endsWith($this.LOGO_FILE())) {
            logoFile$1.elem = configurationDto.value();
            return;
        }
        throw new MatchError((Object)configurationDto);
    }

    public static final /* synthetic */ void $anonfun$updateGeneralSettings$1(GeneralSettingsServiceImpl $this, GeneralSettings generalSettings$1, GeneralSettings sanitizedGeneralSettings$1, String key) {
        String value = "";
        String string = key;
        String string2 = $this.HEADER_COLOR();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            value = generalSettings$1.headerColor();
        } else {
            String string4 = $this.INSTANCE_NAME();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                value = generalSettings$1.instanceName();
            } else {
                String string6 = $this.LOGIN_SCREEN_MESSAGE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    value = $this.sanitizeHtml(generalSettings$1.loginScreenMessage());
                } else {
                    String string8 = $this.LOGO_FILE();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        value = sanitizedGeneralSettings$1.logoFile();
                    } else {
                        throw new MatchError((Object)string);
                    }
                }
            }
        }
        $this.configurationRepository.saveOrUpdate(ConfigurationDto$.MODULE$.apply(key.replace("_", " "), key, value));
    }

    public GeneralSettingsServiceImpl(@Autowired ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
        this.HEADER_COLOR = "header_color";
        this.INSTANCE_NAME = "instance_name";
        this.LOGIN_SCREEN_MESSAGE = "login_screen_message";
        this.LOGO_FILE = "logo_file";
        this.svgSafeList = Safelist.basic().addTags(new String[]{"svg", "g", "path", "rect", "circle", "ellipse", "line", "polyline", "polygon", "text", "tspan"}).addAttributes(":all", new String[]{"style", "fill", "fill-rule", "clip-rule", "stroke", "d", "width", "height", "viewBox", "x", "y", "r", "cx", "cy", "points", "transform", "xmlns"}).addProtocols("xlink:href", "http", new String[]{"https"});
    }
}

