/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.model.CreatePersonalAccessTokenForm;
import ai.digital.deploy.sql.model.UserTokensView;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.XldUserTokenService;
import com.xebialabs.deployit.core.rest.api.AbstractUserRestrictedResource;
import com.xebialabs.deployit.core.rest.api.XldUserTokenService$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserTokenService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\u0006\f\u0001aA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0003M\u0001\u0011\u0005S\nC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0006\u0001!\t%a\u0002\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011Q\u0007\u0001\u0005B\u0005]\"a\u0006-mIV\u001bXM\u001d+pW\u0016t7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\taQ\"A\u0002ba&T!AD\b\u0002\tI,7\u000f\u001e\u0006\u0003!E\tAaY8sK*\u0011!cE\u0001\tI\u0016\u0004Hn\\=ji*\u0011A#F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AF\u0001\u0004G>l7\u0001A\n\u0004\u0001ei\u0002C\u0001\u000e\u001c\u001b\u0005Y\u0011B\u0001\u000f\f\u0005y\t%m\u001d;sC\u000e$Xk]3s%\u0016\u001cHO]5di\u0016$'+Z:pkJ\u001cW\r\u0005\u0002\u001fA5\tqD\u0003\u0002\r\u001f%\u0011\u0011e\b\u0002\u001412$Wk]3s)>\\WM\\*feZL7-Z\u0001\u0011kN,'\u000fV8lK:\u001cVM\u001d<jG\u0016\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\u000fM,'O^5dK*\u0011\u0001&E\u0001\tg\u0016\u001cWO]5us&\u0011!&\n\u0002\u0011+N,'\u000fV8lK:\u001cVM\u001d<jG\u0016\f1\"^:feN+'O^5dKB\u0011QFL\u0007\u0002O%\u0011qf\n\u0002\f+N,'oU3sm&\u001cW-A\u000bqe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0013!\u00049sS:\u001c\u0017\u000e]1mI\u0006$\u0018-\u0003\u00027g\t)\u0002K]5oG&\u0004\u0018\r\u001c#bi\u0006\u0004&o\u001c<jI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003:umb\u0004C\u0001\u000e\u0001\u0011\u0015\u0011C\u00011\u0001$\u0011\u0015YC\u00011\u0001-\u0011\u0015\u0001D\u00011\u00012Q\t!a\b\u0005\u0002@\u00156\t\u0001I\u0003\u0002B\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\r#\u0015a\u00024bGR|'/\u001f\u0006\u0003\u000b\u001a\u000bQAY3b]NT!a\u0012%\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011!S\u0001\u0004_J<\u0017BA&A\u0005%\tU\u000f^8xSJ,G-A\u0007hKR,6/\u001a:U_.,gn\u001d\u000b\u0005\u001dr;G\u000e\u0005\u0002P56\t\u0001K\u0003\u0002R%\u0006)Qn\u001c3fY*\u00111\u000bV\u0001\u0004gFd'BA+W\u0003\u0019!W\r\u001d7ps*\u0011q\u000bW\u0001\bI&<\u0017\u000e^1m\u0015\u0005I\u0016AA1j\u0013\tY\u0006K\u0001\bVg\u0016\u0014Hk\\6f]N4\u0016.Z<\t\u000bu+\u0001\u0019\u00010\u0002\rA\fw-\u001b8h!\tyV-D\u0001a\u0015\t\t'-A\u0002ei>T!\u0001D2\u000b\u0005\u0011\f\u0012AB3oO&tW-\u0003\u0002gA\n1\u0001+Y4j]\u001eDQ\u0001[\u0003A\u0002%\fQa\u001c:eKJ\u0004\"a\u00186\n\u0005-\u0004'\u0001C(sI\u0016\u0014\u0018N\\4\t\u000b5,\u0001\u0019\u00018\u0002\u0013Q|7.\u001a8O_R,\u0007CA8y\u001d\t\u0001h\u000f\u0005\u0002ri6\t!O\u0003\u0002t/\u00051AH]8pizR\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003oR\fa\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q\u000f^\u0001\u0015O\u0016$Hk\\6f]N4uN]+tKJt\u0017-\\3\u0015\u000f9kx0!\u0001\u0002\u0004!)aP\u0002a\u0001]\u0006AQo]3s]\u0006lW\rC\u0003^\r\u0001\u0007a\fC\u0003i\r\u0001\u0007\u0011\u000eC\u0003n\r\u0001\u0007a.A\thK:,'/\u0019;f+N,'\u000fV8lK:$2ATA\u0005\u0011\u001d\tYa\u0002a\u0001\u0003\u001b\tQ\"^:feR{7.\u001a8G_Jl\u0007cA(\u0002\u0010%\u0019\u0011\u0011\u0003)\u0003;\r\u0013X-\u0019;f!\u0016\u00148o\u001c8bY\u0006\u001b7-Z:t)>\\WM\u001c$pe6\f\u0001\u0005Z3mKR,Wk]3s)>\\WM\u001c\"z+N,'O\\1nK\u0006sGmQ5JIR1\u0011qCA\u0010\u0003C\u0001B!!\u0007\u0002\u001c5\tA/C\u0002\u0002\u001eQ\u0014A!\u00168ji\")a\u0010\u0003a\u0001]\"9\u00111\u0005\u0005A\u0002\u0005\u0015\u0012\u0001B2j\u0013\u0012\u0004B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0003mC:<'BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012\u0011\u0006\u0002\b\u0013:$XmZ3s\u0003U!W\r\\3uKV\u001bXM\u001d+pW\u0016t')_\"j\u0013\u0012$B!a\u0006\u0002:!9\u00111E\u0005A\u0002\u0005\u0015\u0002f\u0001\u0001\u0002>A!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\u0019\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9%!\u0011\u0003\u0015\r{g\u000e\u001e:pY2,'\u000f")
public class XldUserTokenServiceImpl
extends AbstractUserRestrictedResource
implements XldUserTokenService {
    private final UserTokenService userTokenService;
    private final UserService userService;
    private final PrincipalDataProvider principalDataProvider;

    public UserTokensView getUserTokens(Paging paging, Ordering order, String tokenNote) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(authentication.getName(), paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(authentication.getName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView getTokensForUsername(String username, Paging paging, Ordering order, String tokenNote) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(username, paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(username, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        boolean personalAccessTokenSupported;
        boolean bl;
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        try {
            this.userService.read(username);
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        boolean user = bl;
        boolean bl2 = personalAccessTokenSupported = userData.isFound() || user;
        if (!personalAccessTokenSupported) {
            throw new Checks.IncorrectArgumentException("Personal access tokens are only supported for internal users and external users authenticated via LDAP", new Object[0]);
        }
        Checks.checkArgument((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(userTokenForm.tokenNote())), (String)"Note can't be blank", (Object[])new Object[0]);
        boolean isValidExpiryDate = userTokenForm.expiryDate() != null ? userTokenForm.expiryDate().getTime() > System.currentTimeMillis() : true;
        Checks.checkArgument((boolean)isValidExpiryDate, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.tokenNote().trim();
        userTokenForm.tokenNote_$eq(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        Checks.checkArgument((!xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$generateUserToken$1(userTokenForm, token))) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        XldUserToken userTokens = this.userTokenService.createUserToken(username, userTokenForm.tokenNote(), userTokenForm.expiryDate());
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenViewForCreateToken((Tokens)tokens))).asJava());
    }

    public void deleteUserTokenByUsernameAndCiId(String username, Integer ciId) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        this.userTokenService.deleteUserToken(username, ciId);
    }

    public void deleteUserTokenByCiId(Integer ciId) {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        if (xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$deleteUserTokenByCiId$1(ciId, token)))) {
            this.userTokenService.deleteUserToken(username, ciId);
            return;
        }
        throw new Checks.IncorrectArgumentException("Personal access token ciId[" + ciId + "] does not belong to user[" + username + "]", new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$generateUserToken$1(CreatePersonalAccessTokenForm userTokenForm$1, Tokens token) {
        String string = token.tokenNote();
        String string2 = userTokenForm$1.tokenNote();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteUserTokenByCiId$1(Integer ciId$1, Tokens token) {
        Integer n = token.ciId();
        Integer n2 = ciId$1;
        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
    }

    @Autowired
    public XldUserTokenServiceImpl(UserTokenService userTokenService, UserService userService, PrincipalDataProvider principalDataProvider) {
        this.userTokenService = userTokenService;
        this.userService = userService;
        this.principalDataProvider = principalDataProvider;
    }
}

