/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import ai.digital.deploy.sql.model.CreatePersonalAccessTokenForm;
import ai.digital.deploy.sql.model.UserTokensView;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.XldUserTokenService;
import com.xebialabs.deployit.core.rest.api.AbstractUserRestrictedResource;
import com.xebialabs.deployit.core.rest.api.XldUserTokenService$;
import com.xebialabs.deployit.core.util.TokenGenerator$;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.model.Tokens;
import com.xebialabs.deployit.security.model.XldUserToken;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.service.UserTokenService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\u0006\r\u0001eA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003N\u0001\u0011\u0005c\nC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0002\u001812$Wk]3s)>\\WM\\*feZL7-Z%na2T!!\u0004\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0010!\u0005!!/Z:u\u0015\t\t\"#\u0001\u0003d_J,'BA\n\u0015\u0003!!W\r\u001d7ps&$(BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\r\u0001!D\b\t\u00037qi\u0011\u0001D\u0005\u0003;1\u0011a$\u00112tiJ\f7\r^+tKJ\u0014Vm\u001d;sS\u000e$X\r\u001a*fg>,(oY3\u0011\u0005}\tS\"\u0001\u0011\u000b\u00055\u0001\u0012B\u0001\u0012!\u0005MAF\u000eZ+tKJ$vn[3o'\u0016\u0014h/[2f\u0003A)8/\u001a:U_.,gnU3sm&\u001cW\r\u0005\u0002&U5\taE\u0003\u0002(Q\u000591/\u001a:wS\u000e,'BA\u0015\u0013\u0003!\u0019XmY;sSRL\u0018BA\u0016'\u0005A)6/\u001a:U_.,gnU3sm&\u001cW-A\u0006vg\u0016\u00148+\u001a:wS\u000e,\u0007C\u0001\u00180\u001b\u0005A\u0013B\u0001\u0019)\u0005-)6/\u001a:TKJ4\u0018nY3\u0002+A\u0014\u0018N\\2ja\u0006dG)\u0019;b!J|g/\u001b3feB\u00111GN\u0007\u0002i)\u0011Q\u0007K\u0001\u000eaJLgnY5qC2$\u0017\r^1\n\u0005]\"$!\u0006)sS:\u001c\u0017\u000e]1m\t\u0006$\u0018\r\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tiZD(\u0010\t\u00037\u0001AQa\t\u0003A\u0002\u0011BQ\u0001\f\u0003A\u00025BQ!\r\u0003A\u0002IB#\u0001B \u0011\u0005\u0001[U\"A!\u000b\u0005\t\u001b\u0015AC1o]>$\u0018\r^5p]*\u0011A)R\u0001\bM\u0006\u001cGo\u001c:z\u0015\t1u)A\u0003cK\u0006t7O\u0003\u0002I\u0013\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u0006\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u001b\u001d,G/V:feR{7.\u001a8t)\u0011yU\f[7\u0011\u0005A[V\"A)\u000b\u0005I\u001b\u0016!B7pI\u0016d'B\u0001+V\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-^\u000ba\u0001Z3qY>L(B\u0001-Z\u0003\u001d!\u0017nZ5uC2T\u0011AW\u0001\u0003C&L!\u0001X)\u0003\u001dU\u001bXM\u001d+pW\u0016t7OV5fo\")a,\u0002a\u0001?\u00061\u0001/Y4j]\u001e\u0004\"\u0001\u00194\u000e\u0003\u0005T!AY2\u0002\u0007\u0011$xN\u0003\u0002\u000eI*\u0011QME\u0001\u0007K:<\u0017N\\3\n\u0005\u001d\f'A\u0002)bO&tw\rC\u0003j\u000b\u0001\u0007!.A\u0003pe\u0012,'\u000f\u0005\u0002aW&\u0011A.\u0019\u0002\t\u001fJ$WM]5oO\")a.\u0002a\u0001_\u0006IAo\\6f]:{G/\u001a\t\u0003aft!!]<\u0011\u0005I,X\"A:\u000b\u0005QD\u0012A\u0002\u001fs_>$hHC\u0001w\u0003\u0015\u00198-\u00197b\u0013\tAX/\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=v\u0003Q9W\r\u001e+pW\u0016t7OR8s+N,'O\\1nKRAqJ`A\u0001\u0003\u0007\t)\u0001C\u0003\u0000\r\u0001\u0007q.\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u0015qf\u00011\u0001`\u0011\u0015Ig\u00011\u0001k\u0011\u0015qg\u00011\u0001p\u0003E9WM\\3sCR,Wk]3s)>\\WM\u001c\u000b\u0004\u001f\u0006-\u0001bBA\u0007\u000f\u0001\u0007\u0011qB\u0001\u000ekN,'\u000fV8lK:4uN]7\u0011\u0007A\u000b\t\"C\u0002\u0002\u0014E\u0013Qd\u0011:fCR,\u0007+\u001a:t_:\fG.Q2dKN\u001cHk\\6f]\u001a{'/\\\u0001!I\u0016dW\r^3Vg\u0016\u0014Hk\\6f]\nKXk]3s]\u0006lW-\u00118e\u0007&LE\r\u0006\u0004\u0002\u001a\u0005\u0005\u00121\u0005\t\u0005\u00037\ti\"D\u0001v\u0013\r\ty\"\u001e\u0002\u0005+:LG\u000fC\u0003\u0000\u0011\u0001\u0007q\u000eC\u0004\u0002&!\u0001\r!a\n\u0002\t\rL\u0017\n\u001a\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002,\t9\u0011J\u001c;fO\u0016\u0014\u0018!\u00063fY\u0016$X-V:feR{7.\u001a8Cs\u000eK\u0017\n\u001a\u000b\u0005\u00033\tY\u0004C\u0004\u0002&%\u0001\r!a\n\u0002'\u001d,G/V:fe:\fW.\u001a$peR{7.\u001a8\u0015\u0007=\f\t\u0005\u0003\u0004\u0002D)\u0001\ra\\\u0001\u0006i>\\WM\u001c\u0015\u0004\u0001\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055s)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u0015\u0002L\tQ1i\u001c8ue>dG.\u001a:")
public class XldUserTokenServiceImpl
extends AbstractUserRestrictedResource
implements XldUserTokenService {
    private final UserTokenService userTokenService;
    private final UserService userService;
    private final PrincipalDataProvider principalDataProvider;

    public UserTokensView getUserTokens(Paging paging, Ordering order, String tokenNote) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(authentication.getName(), paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(authentication.getName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView getTokensForUsername(String username, Paging paging, Ordering order, String tokenNote) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        XldUserToken userTokens = this.userTokenService.listUserTokenByUserName(username, paging, order, tokenNote);
        if (userTokens == null) {
            return new UserTokensView(username, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava());
        }
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenView((Tokens)tokens))).asJava());
    }

    public UserTokensView generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        boolean personalAccessTokenSupported;
        boolean bl;
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        try {
            this.userService.read(username);
            bl = true;
        }
        catch (NotFoundException notFoundException) {
            bl = false;
        }
        boolean user = bl;
        boolean bl2 = personalAccessTokenSupported = userData.isFound() || user || true;
        if (!personalAccessTokenSupported) {
            throw new Checks.IncorrectArgumentException("Personal access tokens are only supported for internal users and external users authenticated via LDAP", new Object[0]);
        }
        Checks.checkArgument((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(userTokenForm.tokenNote())), (String)"Note can't be blank", (Object[])new Object[0]);
        boolean isValidExpiryDate = userTokenForm.expiryDate() != null ? userTokenForm.expiryDate().getTime() > System.currentTimeMillis() : true;
        Checks.checkArgument((boolean)isValidExpiryDate, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.tokenNote().trim();
        userTokenForm.tokenNote_$eq(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        Checks.checkArgument((!xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$generateUserToken$1(userTokenForm, token))) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
        XldUserToken userTokens = this.userTokenService.createUserToken(username, userTokenForm.tokenNote(), userTokenForm.expiryDate());
        return new UserTokensView(userTokens.username(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)userTokens.tokens().map((Function1 & Serializable)tokens -> XldUserTokenService$.MODULE$.mapToUserTokenViewForCreateToken((Tokens)tokens))).asJava());
    }

    public void deleteUserTokenByUsernameAndCiId(String username, Integer ciId) {
        this.checkCurrentUserOrPermissions(username, (scala.collection.immutable.Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{PlatformPermissions.ADMIN}));
        this.userTokenService.deleteUserToken(username, ciId);
    }

    public void deleteUserTokenByCiId(Integer ciId) {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        XldUserToken xldUserToken = this.userTokenService.listUserTokenByUserName(username, null, null, null);
        if (xldUserToken.tokens().exists((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)XldUserTokenServiceImpl.$anonfun$deleteUserTokenByCiId$1(ciId, token)))) {
            this.userTokenService.deleteUserToken(username, ciId);
            return;
        }
        throw new Checks.IncorrectArgumentException("Personal access token ciId[" + ciId + "] does not belong to user[" + username + "]", new Object[0]);
    }

    public String getUsernameForToken(String token) {
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        XldUserToken userToken = this.userTokenService.findByUserToken(tokenHash);
        XldUserToken xldUserToken = userToken;
        if (xldUserToken == null) {
            throw new NotFoundException("Token not found: " + token, new Object[0]);
        }
        return userToken.username();
    }

    public static final /* synthetic */ boolean $anonfun$generateUserToken$1(CreatePersonalAccessTokenForm userTokenForm$1, Tokens token) {
        String string = token.tokenNote();
        String string2 = userTokenForm$1.tokenNote();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$deleteUserTokenByCiId$1(Integer ciId$1, Tokens token) {
        Integer n = token.ciId();
        Integer n2 = ciId$1;
        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
    }

    @Autowired
    public XldUserTokenServiceImpl(UserTokenService userTokenService, UserService userService, PrincipalDataProvider principalDataProvider) {
        this.userTokenService = userTokenService;
        this.userService = userService;
        this.principalDataProvider = principalDataProvider;
    }
}

