package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.deployit.checks.Checks.checkArgument;

final class DeploymentUtils {

    private DeploymentUtils() {
    }

    static <T extends ConfigurationItem> T checkAndCast(ConfigurationItem ci, Class<T> clazz) {
        checkArgument(clazz.isAssignableFrom(ci.getClass()), "%s is not a %s", ci, clazz.getSimpleName());
        return clazz.cast(ci);
    }

}
