package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.service.deployment.DeploymentTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import static com.xebialabs.deployit.core.rest.resteasy.Workdir.Clean.ONLY_ON_EXCEPTION;
import static com.xebialabs.deployit.repository.WorkDirFactory.PREVIEW_WORKDIR_PREFIX;
import static com.xebialabs.deployit.repository.WorkDirFactory.TASK_WORKDIR_PREFIX;

@Service
public class DeploymentResource extends AbstractSecuredResource implements com.xebialabs.deployit.engine.api.DeploymentService {

    @Autowired
    private DeploymentTaskService deploymentTaskService;

    @Override
    public boolean isDeployed(String applicationId, String environmentId) {
        logger.trace("isDeployed {}, {}", applicationId, environmentId);
        return deploymentTaskService.isDeployed(applicationId, environmentId);
    }

    @Override
    public Deployment prepareInitial(String versionId, String environmentId) {
        logger.trace("prepareInitial {}, {}", versionId, environmentId);
        return deploymentTaskService.prepareInitial(versionId, environmentId);
    }

    @Override
    public Deployment prepareUpdate(String newVersionId, String deployedApplicationId) {
        logger.trace("prepareUpgrade {}, {}", newVersionId, deployedApplicationId);
        return deploymentTaskService.prepareUpdate(newVersionId, deployedApplicationId);
    }

    @Override
    public Deployment prepareUndeploy(String deployedApplicationId) {
        logger.trace("prepareUndeployApplication {}", deployedApplicationId);
        return deploymentTaskService.prepareUndeploy(deployedApplicationId);
    }

    @Override
    public Deployment prepareAutoDeployeds(Deployment deployment) {
        logger.trace("updateDeployeds {}", deployment);
        return deploymentTaskService.prepareAutoDeployeds(deployment);
    }

    @Override
    public Deployment generateSelectedDeployeds(List<String> deployableIds, Deployment deployment) {
        return this.generateSelectedDeployeds(new SelectedDeployment(deployableIds, deployment));
    }

    @Override
    public Deployment generateSelectedDeployeds(final SelectedDeployment selectedDeployment) {
        return deploymentTaskService.generateSelectedDeployeds(selectedDeployment);
    }

    @Override
    public Deployment generateSingleDeployed(final String deployableId, final String containerId, Type deployedType, Deployment deployment) {
        return deploymentTaskService.generateSingleDeployed(deployableId, containerId, deployedType, deployment);
    }

    @Override
    public Deployment validate(Deployment deployment) {
        return deploymentTaskService.validate(deployment);
    }

    @Workdir(prefix = PREVIEW_WORKDIR_PREFIX)
    @Override
    public TaskPreviewBlock taskPreviewBlock(final Deployment deployment) {
        return deploymentTaskService.taskPreviewBlock(deployment);
    }

    @Workdir(prefix = PREVIEW_WORKDIR_PREFIX)
    @Override
    public StepState taskPreviewBlock(final Deployment deployment, final String blockId, final int stepNr) {
        return deploymentTaskService.taskPreviewBlock(deployment, blockId, stepNr);
    }

    @Workdir(prefix = TASK_WORKDIR_PREFIX, clean = ONLY_ON_EXCEPTION)
    @Override
    public String createTask(final Deployment deployment) {
        return deploymentTaskService.createTask(deployment);
    }

    @Override
    public String rollback(final String taskid) {
        return deploymentTaskService.rollback(taskid);
    }

    @Override
    public Map<String, String> effectiveDictionary(final String environment, final String applicationVersion, final String application, final String container) {
        return deploymentTaskService.effectiveDictionary(environment, applicationVersion, application, container);
    }

    private static final Logger logger = LoggerFactory.getLogger(DeploymentResource.class);
}
