package com.xebialabs.deployit.core.rest.filters

import com.xebialabs.deployit.engine.api.DeploymentService
import grizzled.slf4j.Logging
import com.xebialabs.deployit.repository.sql.cache.CiAppCacheContext
import org.springframework.stereotype.Component

import jakarta.ws.rs.container.{ContainerRequestContext, ContainerRequestFilter, ContainerResponseContext, ContainerResponseFilter, DynamicFeature, ResourceInfo}
import jakarta.ws.rs.core.FeatureContext
import jakarta.ws.rs.ext.Provider

class CiAppCacheRequestFilter extends ContainerRequestFilter {

  override def filter(requestContext: ContainerRequestContext): Unit = {
    CiAppCacheContext.init(true)
  }
}

class CiAppCacheResponseFilter extends ContainerResponseFilter {

  override def filter(requestContext: ContainerRequestContext, responseContext: ContainerResponseContext): Unit = {
    CiAppCacheContext.clear()
  }
}

@Component
@Provider
class AppCacheDynamicBinding extends DynamicFeature with Logging {

  override def configure(resourceInfo: ResourceInfo, context: FeatureContext): Unit = {
    if (classOf[DeploymentService].equals(resourceInfo.getResourceClass)) {
      val method = resourceInfo.getResourceMethod
      if (method.getName.contains("prepareInitial") ||
        method.getName.contains("prepareUpdate") ||
        method.getName.contains("prepareUndeploy") ||
        method.getName.contains("prepareAutoDeployeds") ||
        method.getName.contains("validate")) {
        logger.debug(s"registering CiAppCacheRequestFilter, CiAppCacheResponseFilter for method ${method.getName} in ${resourceInfo.getResourceClass}")
        context.register(classOf[CiAppCacheRequestFilter])
        context.register(classOf[CiAppCacheResponseFilter])
      }
    }
  }
}
