package com.xebialabs.deployit.core.rest.json

import com.xebialabs.deployit.core.rest.json.TaskWriterUtil.writeTaskWithBlock
import com.xebialabs.deployit.engine.api.dto.DeploymentTaskReportLine
import com.xebialabs.xltype.serialization.util.DateUtil
import org.springframework.stereotype.Component

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import jakarta.ws.rs.Produces
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyWriter, Provider}

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class DeploymentTaskReportLineWriter extends MessageBodyWriter[DeploymentTaskReportLine] {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[DeploymentTaskReportLine].isAssignableFrom(`type`)

  override def writeTo(line: DeploymentTaskReportLine,
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = {
    writeTaskWithBlock(
      entityStream,
      List(
        "taskId" -> line.getTaskId,
        "startDate" -> DateUtil.toString(line.getStartDate),
        "completionDate" -> DateUtil.toString(line.getCompletionDate),
        "status" -> line.getStatus,
        "type" -> line.getTaskType,
        "originalType" -> line.getOriginalTaskType,
        "user" -> line.getUser,
        "environment" -> line.getEnvironment,
        "environmentId" -> line.getEnvironmentId,
        "environmentIdWithoutRoot" -> line.getEnvironmentIdWithoutRoot,
        "package" -> line.getDeploymentPackage,
        "rolledBack" -> line.getRolledBack,
        "worker_name" -> line.getWorkerName
      ),
      Option(line.getBlock)
    )
  }
}
